/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.model.Descriptor;
import hudson.plugins.jabber.im.IMException;
import hudson.plugins.jabber.im.IMMessageTargetConversionException;
import hudson.plugins.jabber.im.transport.JabberIMConnectionProvider;
import hudson.plugins.jabber.im.transport.JabberPublisher;
import hudson.plugins.jabber.tools.Assert;
import hudson.tasks.Publisher;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JabberPublisherDescriptor
extends Descriptor<Publisher> {
    private static final String PREFIX = "jabberPlugin.";
    public static final String PARAMETERNAME_PORT = "jabberPlugin.port";
    public static final String PARAMETERNAME_HOSTNAME = "jabberPlugin.hostname";
    public static final String PARAMETERNAME_PRESENCE = "jabberPlugin.exposePresence";
    public static final String PARAMETERNAME_PASSWORD = "jabberPlugin.password";
    public static final String PARAMETERNAME_NICKNAME = "jabberPlugin.nick";
    public static final String PARAMETERNAME_TARGETS = "jabberPlugin.targets";
    private int port = 5222;
    private String hostname = null;
    private String hudsonNickname = "hudson";
    private String hudsonPassword = "secret";
    private boolean exposePresence = true;

    public JabberPublisherDescriptor() {
        super(JabberPublisher.class);
        this.load();
        try {
            JabberIMConnectionProvider.getInstance().createConnection(this);
        }
        catch (IMException dontCare) {
            dontCare.printStackTrace();
        }
    }

    private void applyHostname(HttpServletRequest req) throws Descriptor.FormException {
        String s = req.getParameter(PARAMETERNAME_HOSTNAME);
        if (s != null && s.trim().length() > 0) {
            try {
                InetAddress.getByName(s);
                this.hostname = s;
            }
            catch (UnknownHostException e) {
                throw new Descriptor.FormException("Cannot find Host '" + s + "'.", PARAMETERNAME_HOSTNAME);
            }
        } else {
            this.hostname = null;
        }
    }

    private void applyNickname(HttpServletRequest req) throws Descriptor.FormException {
        this.hudsonNickname = req.getParameter(PARAMETERNAME_NICKNAME);
        if (this.hostname != null && (this.hudsonNickname == null || this.hudsonNickname.trim().length() == 0)) {
            throw new Descriptor.FormException("Account/Nickname cannot be empty.", PARAMETERNAME_NICKNAME);
        }
    }

    private void applyPassword(HttpServletRequest req) throws Descriptor.FormException {
        this.hudsonPassword = req.getParameter(PARAMETERNAME_PASSWORD);
        if (this.hostname != null && this.hudsonPassword == null || this.hudsonPassword.trim().length() == 0) {
            throw new Descriptor.FormException("Password cannot be empty.", PARAMETERNAME_PASSWORD);
        }
    }

    private void applyPort(HttpServletRequest req) throws Descriptor.FormException {
        String p = req.getParameter(PARAMETERNAME_PORT);
        if (p != null) {
            try {
                int i = Integer.parseInt(p);
                if (i < 0 || i > 65535) {
                    throw new Descriptor.FormException("Port out of range.", PARAMETERNAME_PORT);
                }
                this.port = i;
            }
            catch (NumberFormatException e) {
                throw new Descriptor.FormException("Port cannot be parsed.", PARAMETERNAME_PORT);
            }
        }
    }

    private void applyPresence(HttpServletRequest req) {
        this.exposePresence = req.getParameter(PARAMETERNAME_PRESENCE) != null;
    }

    public boolean configure(HttpServletRequest req) throws Descriptor.FormException {
        Assert.isNotNull((Object)req, (String)"Parameter 'req' must not be null.");
        this.applyPresence(req);
        this.applyHostname(req);
        this.applyPort(req);
        this.applyNickname(req);
        this.applyPassword(req);
        try {
            JabberIMConnectionProvider.getInstance().createConnection(this);
        }
        catch (Exception e) {
            throw new Descriptor.FormException("Unable to create Client: " + e, null);
        }
        this.save();
        return super.configure(req);
    }

    public String getDisplayName() {
        return "Jabber Notification";
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getHudsonNickname() {
        return this.hudsonNickname;
    }

    public String getHudsonPassword() {
        return this.hudsonPassword;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isExposePresence() {
        return this.exposePresence;
    }

    public JabberPublisher newInstance(StaplerRequest req) throws Descriptor.FormException {
        Assert.isNotNull((Object)req, (String)"Parameter 'req' must not be null.");
        String t = req.getParameter(PARAMETERNAME_TARGETS);
        try {
            return new JabberPublisher(t);
        }
        catch (IMMessageTargetConversionException e) {
            throw new Descriptor.FormException((Throwable)e, PARAMETERNAME_TARGETS);
        }
    }

    public void shutdown() {
        JabberIMConnectionProvider factory = JabberIMConnectionProvider.getInstance();
        factory.releaseConnection();
    }
}

