/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im;

import hudson.Launcher;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.jabber.NotificationStrategy;
import hudson.plugins.jabber.im.DefaultIMMessageTargetConverter;
import hudson.plugins.jabber.im.GroupChatIMMessageTarget;
import hudson.plugins.jabber.im.IMConnection;
import hudson.plugins.jabber.im.IMException;
import hudson.plugins.jabber.im.IMMessageTarget;
import hudson.plugins.jabber.im.IMMessageTargetConversionException;
import hudson.plugins.jabber.im.IMMessageTargetConverter;
import hudson.plugins.jabber.tools.Assert;
import hudson.plugins.jabber.user.JabberUserProperty;
import hudson.scm.ChangeLogSet;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IMPublisher
extends Publisher {
    private static final IMMessageTargetConverter CONVERTER = new DefaultIMMessageTargetConverter();
    private final List<IMMessageTarget> targets = new LinkedList();
    private final NotificationStrategy notificationStrategy;
    private final boolean notifyOnBuildStart;
    private final boolean notifySuspects;
    private final boolean notifyFixers;

    protected IMPublisher(String targetsAsString, String notificationStrategyString, boolean notifyGroupChatsOnBuildStart, boolean notifySuspects, boolean notifyFixers) throws IMMessageTargetConversionException {
        Assert.isNotNull((Object)targetsAsString, (String)"Parameter 'targetsAsString' must not be null.");
        String[] split = targetsAsString.split("\\s");
        IMMessageTargetConverter conv = this.getIMMessageTargetConverter();
        for (String fragment : split) {
            IMMessageTarget createIMMessageTarget = conv.fromString(fragment);
            if (createIMMessageTarget == null) continue;
            this.targets.add(createIMMessageTarget);
        }
        this.notificationStrategy = notificationStrategyString == null ? NotificationStrategy.STATECHANGE_ONLY : (notificationStrategyString.equals("all") ? NotificationStrategy.ALL : (notificationStrategyString.equals("failure") ? NotificationStrategy.ANY_FAILURE : NotificationStrategy.STATECHANGE_ONLY));
        this.notifyOnBuildStart = notifyGroupChatsOnBuildStart;
        this.notifySuspects = notifySuspects;
        this.notifyFixers = notifyFixers;
    }

    protected abstract IMConnection getIMConnection() throws IMException;

    protected IMMessageTargetConverter getIMMessageTargetConverter() {
        return CONVERTER;
    }

    protected NotificationStrategy getNotificationStrategy() {
        return this.notificationStrategy;
    }

    private List<IMMessageTarget> getNotificationTargets() {
        return this.targets;
    }

    public final String getTargets() {
        StringBuffer sb = new StringBuffer();
        for (IMMessageTarget t : this.targets) {
            if (t instanceof GroupChatIMMessageTarget && !t.toString().contains("@conference.")) {
                sb.append("*");
            }
            sb.append(t.toString());
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    public final String getStrategy() {
        if (this.getNotificationStrategy() == NotificationStrategy.ALL) {
            return "all";
        }
        if (this.getNotificationStrategy() == NotificationStrategy.ANY_FAILURE) {
            return "failure";
        }
        return "change";
    }

    public final boolean getNotifyOnStart() {
        return this.notifyOnBuildStart;
    }

    public final boolean getNotifySuspects() {
        return this.notifySuspects;
    }

    public final boolean getNotifyFixers() {
        return this.notifyFixers;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener buildListener) throws InterruptedException, IOException {
        String message;
        Assert.isNotNull(build, (String)"Parameter 'build' must not be null.");
        Assert.isNotNull((Object)buildListener, (String)"Parameter 'arg2' must not be null.");
        if (this.getNotificationStrategy().notificationWanted(build)) {
            StringBuffer sb = new StringBuffer();
            sb.append("Project ").append(((Project)build.getProject()).getName()).append(" build (").append(build.getNumber()).append("): ").append(build.getResult()).append(" in ").append(build.getDurationString()).append(": ").append(Hudson.getInstance().getRootUrl()).append(build.getUrl());
            if (build.getChangeSet() != null && !build.getChangeSet().isEmptySet()) {
                boolean hasManyChangeSets = build.getChangeSet().getItems().length > 1;
                for (ChangeLogSet.Entry entry : build.getChangeSet()) {
                    sb.append("\n");
                    if (hasManyChangeSets) {
                        sb.append("* ");
                    }
                    sb.append(entry.getAuthor()).append(": ").append(entry.getMsg());
                }
            }
            String msg = sb.toString();
            for (IMMessageTarget target : this.getNotificationTargets()) {
                try {
                    buildListener.getLogger().append("Sending notification to: " + target.toString() + "\n");
                    this.getIMConnection().send(target, msg);
                }
                catch (Throwable e) {
                    buildListener.getLogger().append("There was an Error sending notification to: " + target.toString() + "\n");
                }
            }
        }
        if (this.notifySuspects && build.getResult().isWorseThan(Result.SUCCESS)) {
            message = new StringBuffer("You're suspected of having broken ").append(((Project)build.getProject()).getName()).append(": ").append(Hudson.getInstance().getRootUrl()).append(build.getUrl()).toString();
            for (IMMessageTarget target : this.calculateSuspectsTargets(build.getChangeSet())) {
                try {
                    this.getIMConnection().send(target, message);
                }
                catch (Throwable e) {
                    buildListener.getLogger().append("There was an Error sending suspect notification to: " + target.toString() + "\n");
                }
            }
        }
        if (this.notifyFixers && build.getResult() == Result.SUCCESS && build.getPreviousBuild() != null && ((Build)build.getPreviousBuild()).getResult().isWorseThan(Result.SUCCESS)) {
            message = new StringBuffer("Seems you've fixed  ").append(((Project)build.getProject()).getName()).append(": ").append(Hudson.getInstance().getRootUrl()).append(build.getUrl()).toString();
            for (IMMessageTarget target : this.calculateSuspectsTargets(build.getChangeSet())) {
                try {
                    this.getIMConnection().send(target, message);
                }
                catch (Throwable e) {
                    buildListener.getLogger().append("There was an Error sending fixer notification to: " + target.toString() + "\n");
                }
            }
        }
        return true;
    }

    public boolean prebuild(Build build, BuildListener buildListener) {
        try {
            if (this.notifyOnBuildStart) {
                StringBuffer sb = new StringBuffer("Starting build ").append(build.getNumber()).append(" for job ").append(build.getProject().getName());
                if (build.getPreviousBuild() != null) {
                    sb.append(" (previous build: ").append(build.getPreviousBuild().getResult().toString().toLowerCase());
                    if (build.getPreviousBuild().getResult().isWorseThan(Result.SUCCESS)) {
                        sb.append(" -- last ").append(build.getPreviousNotFailedBuild().getResult().toString().toLowerCase()).append(" #").append(build.getPreviousNotFailedBuild().getNumber()).append(" ").append(build.getPreviousNotFailedBuild().getTimestampString()).append(" ago");
                    }
                    sb.append(")");
                }
                String msg = sb.toString();
                for (IMMessageTarget target : this.getNotificationTargets()) {
                    if (!(target instanceof GroupChatIMMessageTarget)) continue;
                    try {
                        this.getIMConnection().send(target, msg);
                    }
                    catch (Throwable e) {
                        buildListener.getLogger().append("There was an Error sending notification to: " + target.toString() + "\n");
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    private Collection<IMMessageTarget> calculateSuspectsTargets(ChangeLogSet<? extends ChangeLogSet.Entry> changeLogSet) {
        HashSet<IMMessageTarget> suspects = new HashSet<IMMessageTarget>();
        if (changeLogSet != null && !changeLogSet.isEmptySet()) {
            for (ChangeLogSet.Entry e : changeLogSet) {
                JabberUserProperty jabberUserProperty = (JabberUserProperty)e.getAuthor().getProperties().get(JabberUserProperty.DESCRIPTOR);
                if (jabberUserProperty == null || jabberUserProperty.getJid() == null) continue;
                try {
                    suspects.add(CONVERTER.fromString(jabberUserProperty.getJid()));
                }
                catch (IMMessageTargetConversionException dontCare) {}
            }
        }
        return suspects;
    }
}

