/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport.bot;

import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.model.Queue;
import hudson.plugins.jabber.im.transport.bot.BotCommand;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;

public class BuildCommand
implements BotCommand {
    private static final Pattern NUMERIC_EXTRACTION_REGEX = Pattern.compile("^(\\d+)");
    private static final String HELP = " <job> [now|<delay[s|m|h]>] - schedule a job build, with standard, custom or no quiet period";
    private final String buildNowCommand;

    public BuildCommand() {
        this.buildNowCommand = "build";
    }

    public BuildCommand(String buildNowCommand) {
        this.buildNowCommand = buildNowCommand;
    }

    private boolean scheduleBuild(Project project, int delaySeconds) {
        Queue queue = Hudson.getInstance().getQueue();
        if (queue == null) {
            return false;
        }
        if (queue.getItem((AbstractProject)project) != null) {
            return false;
        }
        try {
            Field queueField = queue.getClass().getDeclaredField("queue");
            queueField.setAccessible(true);
            Set q = (Set)queueField.get(queue);
            GregorianCalendar due = new GregorianCalendar();
            ((Calendar)due).add(13, delaySeconds);
            Queue queue2 = queue;
            queue2.getClass();
            Queue.Item item = new Queue.Item(queue2, (Calendar)due, (Queue.Task)project);
            q.add(item);
            queue.scheduleMaintenance();
            return true;
        }
        catch (Exception e) {
            return project.scheduleBuild();
        }
    }

    public void executeCommand(GroupChat groupChat, Message message, String sender, String[] args) throws XMPPException {
        if (args.length >= 2) {
            String jobName = args[1];
            Project project = (Project)Hudson.getInstance().getItemByFullName(jobName, Project.class);
            if (project != null) {
                if (project.isInQueue()) {
                    Queue.Item queueItem = project.getQueueItem();
                    groupChat.sendMessage(new StringBuffer(sender).append(": job ").append(jobName).append(" is already in the build queue (").append(queueItem.getWhy()).append(")").toString());
                } else if (project.isDisabled()) {
                    groupChat.sendMessage(new StringBuffer(sender).append(": job ").append(jobName).append(" is disabled").toString());
                } else if (args.length <= 2 && args[0].equals(this.buildNowCommand) || "now".equalsIgnoreCase(args[2])) {
                    if (this.scheduleBuild(project, 1)) {
                        groupChat.sendMessage(new StringBuffer(sender).append(": job ").append(jobName).append(" build scheduled now").toString());
                    } else {
                        groupChat.sendMessage(new StringBuffer(sender).append(": job ").append(jobName).append(" scheduling failed or already in build queue").toString());
                    }
                } else if (args.length >= 3) {
                    String delay = args[2].trim();
                    int factor = 1;
                    if (delay.endsWith("m") || delay.endsWith("min")) {
                        factor = 60;
                    } else if (delay.endsWith("h")) {
                        factor = 3600;
                    }
                    Matcher matcher = NUMERIC_EXTRACTION_REGEX.matcher(delay);
                    if (matcher.find()) {
                        int value = Integer.parseInt(matcher.group());
                        if (this.scheduleBuild(project, value * factor)) {
                            groupChat.sendMessage(new StringBuffer(sender).append(": job ").append(jobName).append(" build scheduled with a quiet period of ").append(value * factor).append(" seconds").toString());
                        } else {
                            groupChat.sendMessage(new StringBuffer(sender).append(": job ").append(jobName).append(" already scheduled in build queue").toString());
                        }
                    }
                } else if (project.scheduleBuild()) {
                    groupChat.sendMessage(new StringBuffer(sender).append(": job ").append(jobName).append(" build scheduled (quiet period: ").append(project.getQuietPeriod()).append(" seconds)").toString());
                } else {
                    groupChat.sendMessage(new StringBuffer(sender).append(": job ").append(jobName).append(" already scheduled in build queue").toString());
                }
            } else {
                groupChat.sendMessage(new StringBuffer(sender).append(": unknown job ").append(jobName).toString());
            }
        }
    }

    public String getHelp() {
        return HELP;
    }
}

