/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport.bot;

import hudson.model.Build;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.plugins.jabber.im.transport.bot.BotCommand;
import java.util.ArrayList;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;

public class StatusCommand
implements BotCommand {
    private static final String HELP = " [<job>] - show the status of a specific or all jobs";

    public void executeCommand(GroupChat groupChat, Message message, String sender, String[] args) throws XMPPException {
        ArrayList<Project> projects = new ArrayList<Project>(0);
        if (args.length >= 2) {
            String jobName = args[1];
            Project project = (Project)Hudson.getInstance().getItemByFullName(jobName, Project.class);
            if (project != null) {
                projects.add(project);
            } else {
                groupChat.sendMessage(new StringBuffer(sender).append(": unknown job ").append(jobName).toString());
            }
        } else if (args.length == 1) {
            for (Project project : Hudson.getInstance().getProjects()) {
                projects.add(project);
            }
        }
        if (!projects.isEmpty()) {
            StringBuffer msg = new StringBuffer();
            if (projects.size() > 1) {
                msg.append("Status of all projects:\n");
            }
            boolean first = true;
            for (Project project : projects) {
                Build lastBuild;
                if (!first) {
                    msg.append("\n");
                } else {
                    first = false;
                }
                msg.append(project.getName());
                if (project.isDisabled()) {
                    msg.append("(disabled) ");
                } else if (project.isInQueue()) {
                    msg.append("(in queue) ");
                } else if (project.isBuilding()) {
                    msg.append("(BUILDING) ");
                }
                msg.append(": ");
                for (lastBuild = (Build)project.getLastBuild(); lastBuild != null && lastBuild.isBuilding(); lastBuild = (Build)lastBuild.getPreviousBuild()) {
                }
                if (lastBuild != null) {
                    msg.append("last build: ").append(lastBuild.getNumber()).append(": ").append(lastBuild.getResult()).append(": ").append(Hudson.getInstance().getRootUrl()).append(lastBuild.getUrl());
                    continue;
                }
                msg.append("no finished build yet");
            }
            groupChat.sendMessage(msg.toString());
        }
    }

    public String getHelp() {
        return HELP;
    }
}

