/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber;

import hudson.model.Build;
import hudson.model.Result;
import hudson.plugins.jabber.tools.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NotificationStrategy {
    STATECHANGE_ONLY{

        @Override
        public boolean notificationWanted(Build<?, ?> build) {
            Assert.isNotNull(build, "Parameter 'build' must not be null.");
            Build previousBuild = (Build)build.getPreviousBuild();
            return previousBuild == null || build.getResult() != previousBuild.getResult();
        }
    }
    ,
    ALL{

        public boolean notificationWanted(Build build) {
            return true;
        }
    }
    ,
    ANY_FAILURE{

        @Override
        public boolean notificationWanted(Build<?, ?> build) {
            Assert.isNotNull(build, "Parameter 'build' must not be null.");
            return build.getResult() != Result.SUCCESS;
        }
    };


    public abstract boolean notificationWanted(Build<?, ?> var1);
}

