/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.jabber.tools.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NotificationStrategy {
    STATECHANGE_ONLY{

        @Override
        public boolean notificationWanted(AbstractBuild<?, ?> build) {
            Assert.isNotNull(build, "Parameter 'build' must not be null.");
            AbstractBuild previousBuild = (AbstractBuild)build.getPreviousBuild();
            return previousBuild == null || build.getResult() != previousBuild.getResult();
        }
    }
    ,
    ALL{

        @Override
        public boolean notificationWanted(AbstractBuild<?, ?> build) {
            return true;
        }
    }
    ,
    ANY_FAILURE{

        @Override
        public boolean notificationWanted(AbstractBuild<?, ?> build) {
            Assert.isNotNull(build, "Parameter 'build' must not be null.");
            return build.getResult() != Result.SUCCESS;
        }
    };


    public abstract boolean notificationWanted(AbstractBuild<?, ?> var1);
}

