/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.Util;
import hudson.model.Descriptor;
import hudson.plugins.jabber.im.IMException;
import hudson.plugins.jabber.im.IMMessageTargetConversionException;
import hudson.plugins.jabber.im.transport.JabberIMConnectionProvider;
import hudson.plugins.jabber.im.transport.JabberPublisher;
import hudson.plugins.jabber.tools.Assert;
import hudson.tasks.Publisher;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JabberPublisherDescriptor
extends Descriptor<Publisher> {
    private static final String PREFIX = "jabberPlugin.";
    public static final String PARAMETERNAME_PORT = "jabberPlugin.port";
    public static final String PARAMETERNAME_HOSTNAME = "jabberPlugin.hostname";
    public static final String PARAMETERNAME_PRESENCE = "jabberPlugin.exposePresence";
    public static final String PARAMETERNAME_PASSWORD = "jabberPlugin.password";
    public static final String PARAMETERNAME_NICKNAME = "jabberPlugin.nick";
    public static final String PARAMETERNAME_TARGETS = "jabberPlugin.targets";
    public static final String PARAMETERNAME_STRATEGY = "jabberPlugin.strategy";
    public static final String PARAMETERNAME_NOTIFY_START = "jabberPlugin.notifyStart";
    public static final String PARAMETERNAME_NOTIFY_SUSPECTS = "jabberPlugin.notifySuspects";
    public static final String PARAMETERNAME_NOTIFY_FIXERS = "jabberPlugin.notifyFixers";
    public static final String PARAMETERNAME_INITIAL_GROUPCHATS = "jabberPlugin.initialGroupChats";
    public static final String PARAMETERNAME_COMMAND_PREFIX = "jabberPlugin.commandPrefix";
    public static final String PARAMETERVALUE_STRATEGY_ALL = "all";
    public static final String PARAMETERVALUE_STRATEGY_FAILURE = "failure";
    public static final String PARAMETERVALUE_STRATEGY_STATE_CHANGE = "change";
    public static final String[] PARAMETERVALUE_STRATEGY_VALUES = new String[]{"all", "failure", "change"};
    public static final String PARAMETERVALUE_STRATEGY_DEFAULT = "change";
    public static final String DEFAULT_COMMAND_PREFIX = "!";
    private int port = 5222;
    private String hostname = null;
    private String hudsonNickname = "hudson";
    private String hudsonPassword = "secret";
    private boolean exposePresence = true;
    private String initialGroupChats = null;
    private String commandPrefix = "!";

    public JabberPublisherDescriptor() {
        super(JabberPublisher.class);
        this.load();
        try {
            JabberIMConnectionProvider.getInstance().createConnection(this);
        }
        catch (IMException dontCare) {
            dontCare.printStackTrace();
        }
    }

    private void applyHostname(HttpServletRequest req) throws Descriptor.FormException {
        String s = req.getParameter(PARAMETERNAME_HOSTNAME);
        if (s != null && s.trim().length() > 0) {
            try {
                InetAddress.getByName(s);
                this.hostname = s;
            }
            catch (UnknownHostException e) {
                throw new Descriptor.FormException("Cannot find Host '" + s + "'.", PARAMETERNAME_HOSTNAME);
            }
        } else {
            this.hostname = null;
        }
    }

    private void applyNickname(HttpServletRequest req) throws Descriptor.FormException {
        this.hudsonNickname = req.getParameter(PARAMETERNAME_NICKNAME);
        if (this.hostname != null && (this.hudsonNickname == null || this.hudsonNickname.trim().length() == 0)) {
            throw new Descriptor.FormException("Account/Nickname cannot be empty.", PARAMETERNAME_NICKNAME);
        }
    }

    private void applyPassword(HttpServletRequest req) throws Descriptor.FormException {
        this.hudsonPassword = req.getParameter(PARAMETERNAME_PASSWORD);
        if (this.hostname != null && this.hudsonPassword == null || this.hudsonPassword.trim().length() == 0) {
            throw new Descriptor.FormException("Password cannot be empty.", PARAMETERNAME_PASSWORD);
        }
    }

    private void applyPort(HttpServletRequest req) throws Descriptor.FormException {
        String p = Util.fixEmptyAndTrim((String)req.getParameter(PARAMETERNAME_PORT));
        if (p != null) {
            try {
                int i = Integer.parseInt(p);
                if (i < 0 || i > 65535) {
                    throw new Descriptor.FormException("Port out of range.", PARAMETERNAME_PORT);
                }
                this.port = i;
            }
            catch (NumberFormatException e) {
                throw new Descriptor.FormException("Port cannot be parsed.", PARAMETERNAME_PORT);
            }
        } else {
            this.port = 5222;
        }
    }

    private void applyPresence(HttpServletRequest req) {
        this.exposePresence = req.getParameter(PARAMETERNAME_PRESENCE) != null;
    }

    private void applyInitialGroupChats(HttpServletRequest req) {
        this.initialGroupChats = Util.fixEmptyAndTrim((String)req.getParameter(PARAMETERNAME_INITIAL_GROUPCHATS));
    }

    private void applyCommandPrefix(HttpServletRequest req) {
        String commandPrefix = req.getParameter(PARAMETERNAME_COMMAND_PREFIX);
        this.commandPrefix = commandPrefix != null && commandPrefix.trim().length() > 0 ? commandPrefix : DEFAULT_COMMAND_PREFIX;
    }

    public String getDisplayName() {
        return "Jabber Notification";
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getHudsonNickname() {
        return this.hudsonNickname;
    }

    public String getHudsonPassword() {
        return this.hudsonPassword;
    }

    public int getPort() {
        return this.port;
    }

    public String getPortString() {
        if (this.port == 5222) {
            return null;
        }
        return String.valueOf(this.port);
    }

    public boolean isExposePresence() {
        return this.exposePresence;
    }

    public String getInitialGroupChats() {
        return Util.fixEmptyAndTrim((String)this.initialGroupChats);
    }

    public String getCommandPrefix() {
        return this.commandPrefix;
    }

    public JabberPublisher newInstance(StaplerRequest req) throws Descriptor.FormException {
        Assert.isNotNull(req, "Parameter 'req' must not be null.");
        String t = req.getParameter(PARAMETERNAME_TARGETS);
        String n = req.getParameter(PARAMETERNAME_STRATEGY);
        if (n == null) {
            n = "change";
        } else {
            boolean foundStrategyValueMatch = false;
            for (String strategyValue : PARAMETERVALUE_STRATEGY_VALUES) {
                if (!strategyValue.equals(n)) continue;
                foundStrategyValueMatch = true;
                break;
            }
            if (!foundStrategyValueMatch) {
                n = "change";
            }
        }
        String s = req.getParameter(PARAMETERNAME_NOTIFY_START);
        String ns = req.getParameter(PARAMETERNAME_NOTIFY_SUSPECTS);
        String nf = req.getParameter(PARAMETERNAME_NOTIFY_FIXERS);
        try {
            return new JabberPublisher(t, n, s != null && "on".equals(s), ns != null && "on".equals(ns), nf != null && "on".equals(nf));
        }
        catch (IMMessageTargetConversionException e) {
            throw new Descriptor.FormException((Throwable)e, PARAMETERNAME_TARGETS);
        }
    }

    public void shutdown() {
        JabberIMConnectionProvider factory = JabberIMConnectionProvider.getInstance();
        factory.releaseConnection();
    }

    public boolean configure(StaplerRequest req) throws Descriptor.FormException {
        Assert.isNotNull(req, "Parameter 'req' must not be null.");
        this.applyPresence((HttpServletRequest)req);
        this.applyHostname((HttpServletRequest)req);
        this.applyPort((HttpServletRequest)req);
        this.applyNickname((HttpServletRequest)req);
        this.applyPassword((HttpServletRequest)req);
        this.applyInitialGroupChats((HttpServletRequest)req);
        this.applyCommandPrefix((HttpServletRequest)req);
        try {
            JabberIMConnectionProvider.getInstance().createConnection(this);
        }
        catch (Exception e) {
            throw new Descriptor.FormException("Unable to create Client: " + e, null);
        }
        this.save();
        return super.configure(req);
    }

    public void doServerCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        new FormFieldValidator(req, rsp, false){

            protected void check() throws IOException, ServletException {
                String v = Util.fixEmptyAndTrim((String)this.request.getParameter("value"));
                if (v == null) {
                    this.ok();
                } else {
                    try {
                        InetAddress.getByName(v);
                        this.ok();
                    }
                    catch (UnknownHostException e) {
                        this.error("Unknown host " + v);
                    }
                }
            }
        }.process();
    }
}

