/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.tools;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class MessageHelper {
    public static final Logger LOGGER = Logger.getLogger(MessageHelper.class.toString());
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s");
    private static final String QUOTE = "\"";

    public static String getBuildURL(AbstractBuild<?, ?> lastBuild) {
        StringBuilder builder = new StringBuilder(Hudson.getInstance().getRootUrl());
        builder.append(Util.encode((String)lastBuild.getUrl()));
        return builder.toString();
    }

    public static String[] extractCommandLine(String message) {
        return MessageHelper.extractParameters((String)message).toArray(new String[0]);
    }

    private static List<String> extractParameters(String commandLine) {
        ArrayList<String> parameters = new ArrayList<String>();
        if ((commandLine = commandLine.trim()).contains("\"")) {
            int firstQuote = commandLine.indexOf("\"");
            if (firstQuote == 0) {
                int end = commandLine.indexOf("\"", 1);
                parameters.add(commandLine.substring(1, end - 1));
            } else {
                parameters.addAll(MessageHelper.extractParameters((String)commandLine.substring(0, firstQuote)));
                int endQuoted = commandLine.indexOf("\"", firstQuote + 1);
                parameters.add(commandLine.substring(firstQuote + 1, endQuoted));
                if (endQuoted < commandLine.length() - 1) {
                    parameters.addAll(MessageHelper.extractParameters((String)commandLine.substring(endQuoted + 1)));
                }
            }
        } else {
            Collections.addAll(parameters, SPACE_PATTERN.split(commandLine));
        }
        return parameters;
    }
}

