/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.jabber.im.GroupChatIMMessageTarget;
import hudson.plugins.jabber.im.IMConnection;
import hudson.plugins.jabber.im.IMException;
import hudson.plugins.jabber.im.IMMessageTarget;
import hudson.plugins.jabber.im.IMPresence;
import hudson.plugins.jabber.im.transport.JabberPublisherDescriptor;
import hudson.plugins.jabber.im.transport.bot.Bot;
import hudson.plugins.jabber.tools.Assert;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SSLXMPPConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;

class JabberIMConnection
implements IMConnection {
    private static final String DND_MESSAGE = "I'm busy building your software...";
    private XMPPConnection connection;
    private final Object connectionLock = new Object();
    private Map<String, GroupChatCacheEntry> groupChatCache = new HashMap<String, GroupChatCacheEntry>(0);
    private final String passwd;
    private final String botCommandPrefix;
    private final String nick;
    private final String groupChatNick;
    private final String hostname;
    private final int port;
    private final boolean legacySSL;

    JabberIMConnection(JabberPublisherDescriptor desc) throws IMException {
        Assert.isNotNull((Object)desc, "Parameter 'desc' must not be null.");
        this.hostname = desc.getHostname();
        this.port = desc.getPort();
        this.legacySSL = desc.isLegacySSL();
        this.nick = desc.getHudsonNickname();
        this.passwd = desc.getHudsonPassword();
        this.groupChatNick = desc.getGroupChatNickname() != null ? desc.getGroupChatNickname() : this.nick;
        this.botCommandPrefix = desc.getCommandPrefix();
        try {
            this.createConnection();
            if (desc.getInitialGroupChats() != null) {
                for (String groupChatName : desc.getInitialGroupChats().trim().split("\\s")) {
                    this.createGroupChatConnection(groupChatName.trim());
                }
            }
        }
        catch (XMPPException dontCare) {
            dontCare.printStackTrace();
        }
    }

    public String getServiceName() {
        int idx = this.nick.indexOf(64);
        if (idx < 0) {
            return null;
        }
        return this.nick.substring(idx + 1);
    }

    public String getUserName() {
        int idx = this.nick.indexOf(64);
        if (idx < 0) {
            return this.nick;
        }
        return this.nick.substring(0, idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.connectionLock;
        synchronized (object) {
            try {
                if (this.connection != null && this.connection.isConnected()) {
                    for (GroupChatCacheEntry entry : this.groupChatCache.values()) {
                        if (!entry.getGroupChat().isJoined()) continue;
                        entry.getGroupChat().leave();
                    }
                    this.connection.close();
                }
            }
            finally {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createConnection() throws XMPPException {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.connection == null || !this.connection.isConnected()) {
                String serviceName = this.getServiceName();
                this.connection = serviceName == null ? (this.legacySSL ? new SSLXMPPConnection(this.hostname, this.port) : new XMPPConnection(this.hostname, this.port)) : (this.hostname == null ? (this.legacySSL ? new SSLXMPPConnection(serviceName) : new XMPPConnection(serviceName)) : (this.legacySSL ? new SSLXMPPConnection(this.hostname, this.port, serviceName) : new XMPPConnection(this.hostname, this.port, serviceName)));
                this.connection.login(this.getUserName(), this.passwd, "Hudson");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroupChat createGroupChatConnection(String groupChatName) throws XMPPException {
        Object object = this.connectionLock;
        synchronized (object) {
            this.createConnection();
            GroupChatCacheEntry cacheEntry = this.groupChatCache.get(groupChatName);
            if (cacheEntry == null) {
                GroupChat groupChat = this.connection.createGroupChat(groupChatName);
                groupChat.join(this.groupChatNick);
                while (groupChat.pollMessage() != null) {
                }
                Bot bot = new Bot(groupChat, this.groupChatNick, this.botCommandPrefix);
                cacheEntry = new GroupChatCacheEntry(groupChat, bot);
                this.groupChatCache.put(groupChatName, cacheEntry);
                groupChat.addMessageListener((PacketListener)bot);
            }
            return cacheEntry.getGroupChat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(IMMessageTarget target, String text) throws IMException {
        Assert.isNotNull(target, "Parameter 'target' must not be null.");
        Assert.isNotNull(text, "Parameter 'text' must not be null.");
        try {
            Object object = this.connectionLock;
            synchronized (object) {
                this.createConnection();
                if (target instanceof GroupChatIMMessageTarget) {
                    this.createGroupChatConnection(target.toString()).sendMessage(text);
                } else {
                    Chat chat = this.connection.createChat(target.toString());
                    chat.sendMessage(text);
                }
            }
        }
        catch (XMPPException dontCare) {
            dontCare.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPresence(IMPresence impresence) throws IMException {
        Assert.isNotNull((Object)impresence, "Parameter 'impresence' must not be null.");
        try {
            Presence presence;
            this.createConnection();
            switch (impresence) {
                case AVAILABLE: {
                    presence = new Presence(Presence.Type.AVAILABLE, DND_MESSAGE, 1, Presence.Mode.DO_NOT_DISTURB);
                    break;
                }
                case UNAVAILABLE: {
                    presence = new Presence(Presence.Type.UNAVAILABLE);
                    break;
                }
                default: {
                    throw new IllegalStateException("Don't know how to handle " + (Object)((Object)impresence));
                }
            }
            Object object = this.connectionLock;
            synchronized (object) {
                this.connection.sendPacket((Packet)presence);
            }
        }
        catch (XMPPException e) {
            throw new IMException((Exception)((Object)e));
        }
    }

    private static class GroupChatCacheEntry {
        private final GroupChat groupChat;
        private final Bot bot;

        public GroupChatCacheEntry(GroupChat groupChat, Bot bot) {
            this.groupChat = groupChat;
            this.bot = bot;
        }

        public GroupChat getGroupChat() {
            return this.groupChat;
        }

        public Bot getBot() {
            return this.bot;
        }
    }
}

