/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport.bot;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.plugins.jabber.im.transport.bot.BotCommand;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;

public class AbortCommand
implements BotCommand {
    private static final String HELP = " <job> - specify which job to abort";

    public void executeCommand(GroupChat groupChat, Message message, String sender, String[] args) throws XMPPException {
        Executor ex;
        String jobName;
        if (args.length >= 2) {
            jobName = args[1];
            jobName = jobName.replaceAll("\"", "");
            AbstractProject project = (AbstractProject)Hudson.getInstance().getItemByFullName(jobName, AbstractProject.class);
            if (project == null) {
                groupChat.sendMessage(new StringBuffer(sender).append(": that doesn't look like a valid job").toString());
                return;
            }
            if (!project.isInQueue() && !project.isBuilding()) {
                groupChat.sendMessage(String.format("%s: how do you intend a build that isn't building?", sender));
                return;
            }
            AbstractBuild build = (AbstractBuild)project.getLastBuild();
            if (build == null) {
                groupChat.sendMessage(new StringBuffer(sender).append(": it appears this job has never been built").toString());
                return;
            }
            ex = build.getExecutor();
            if (ex == null) {
                return;
            }
        } else {
            groupChat.sendMessage(new StringBuffer(sender).append(": you need to specify a job name").toString());
            return;
        }
        ex.interrupt();
        groupChat.sendMessage(String.format("%s aborted, I hope you're happy!", jobName));
    }

    public String getHelp() {
        return HELP;
    }
}

