/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport.bot;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.plugins.jabber.im.transport.bot.BotCommand;
import hudson.plugins.jabber.tools.MessageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;

public class StatusCommand
implements BotCommand {
    private static final String HELP = " [<job>] - show the status of a specific or all jobs";

    public void executeCommand(GroupChat groupChat, Message message, String sender, String[] args) throws XMPPException {
        ArrayList<AbstractProject> projects = new ArrayList<AbstractProject>(0);
        if (args.length >= 2) {
            String jobName = StringUtils.join((Object[])Arrays.copyOfRange(args, 1, args.length), (String)" ");
            jobName = jobName.replaceAll("\"", "");
            AbstractProject project = (AbstractProject)Hudson.getInstance().getItemByFullName(jobName, AbstractProject.class);
            if (project != null) {
                projects.add(project);
            } else {
                groupChat.sendMessage(new StringBuffer(sender).append(": unknown job ").append(jobName).toString());
            }
        } else if (args.length == 1) {
            for (AbstractProject project : Hudson.getInstance().getAllItems(AbstractProject.class)) {
                if (!Hudson.getInstance().equals(project.getParent())) continue;
                projects.add(project);
            }
        }
        if (!projects.isEmpty()) {
            StringBuffer msg = new StringBuffer();
            if (projects.size() > 1) {
                msg.append("Status of all projects:\n");
            }
            boolean first = true;
            for (AbstractProject project : projects) {
                AbstractBuild lastBuild;
                if (!first) {
                    msg.append("\n");
                } else {
                    first = false;
                }
                msg.append(project.getName());
                if (project.isDisabled()) {
                    msg.append("(disabled) ");
                } else if (project.isInQueue()) {
                    msg.append("(in queue) ");
                } else if (project.isBuilding()) {
                    msg.append("(BUILDING) ");
                }
                msg.append(": ");
                for (lastBuild = (AbstractBuild)project.getLastBuild(); lastBuild != null && lastBuild.isBuilding(); lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
                }
                if (lastBuild != null) {
                    msg.append("last build: ").append(lastBuild.getNumber()).append(": ").append(lastBuild.getResult()).append(": ").append(MessageHelper.getBuildURL((AbstractBuild)lastBuild));
                    continue;
                }
                msg.append("no finished build yet");
            }
            groupChat.sendMessage(msg.toString());
        }
    }

    public String getHelp() {
        return HELP;
    }
}

