/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.jabber.NotificationStrategy;
import hudson.plugins.jabber.im.DefaultIMMessageTargetConverter;
import hudson.plugins.jabber.im.GroupChatIMMessageTarget;
import hudson.plugins.jabber.im.IMConnection;
import hudson.plugins.jabber.im.IMException;
import hudson.plugins.jabber.im.IMMessageTarget;
import hudson.plugins.jabber.im.IMMessageTargetConversionException;
import hudson.plugins.jabber.im.IMMessageTargetConverter;
import hudson.plugins.jabber.tools.Assert;
import hudson.plugins.jabber.tools.MessageHelper;
import hudson.plugins.jabber.user.JabberUserProperty;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStep;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class IMPublisher
extends Notifier
implements BuildStep {
    private static final Logger LOGGER = Logger.getLogger(IMPublisher.class.getName());
    private static final IMMessageTargetConverter CONVERTER = new DefaultIMMessageTargetConverter();
    private final List<IMMessageTarget> targets = new LinkedList();
    private final NotificationStrategy notificationStrategy;
    private final boolean notifyOnBuildStart;
    private final boolean notifySuspects;
    private final boolean notifyFixers;

    protected IMPublisher(String targetsAsString, String notificationStrategyString, boolean notifyGroupChatsOnBuildStart, boolean notifySuspects, boolean notifyFixers) throws IMMessageTargetConversionException {
        Assert.isNotNull((Object)targetsAsString, (String)"Parameter 'targetsAsString' must not be null.");
        String[] split = targetsAsString.split("\\s");
        IMMessageTargetConverter conv = this.getIMMessageTargetConverter();
        for (String fragment : split) {
            IMMessageTarget createIMMessageTarget = conv.fromString(fragment);
            if (createIMMessageTarget == null) continue;
            this.targets.add(createIMMessageTarget);
        }
        NotificationStrategy strategy = NotificationStrategy.forDisplayName((String)notificationStrategyString);
        if (strategy == null) {
            strategy = NotificationStrategy.STATECHANGE_ONLY;
        }
        this.notificationStrategy = strategy;
        this.notifyOnBuildStart = notifyGroupChatsOnBuildStart;
        this.notifySuspects = notifySuspects;
        this.notifyFixers = notifyFixers;
    }

    protected abstract IMConnection getIMConnection() throws IMException;

    protected IMMessageTargetConverter getIMMessageTargetConverter() {
        return CONVERTER;
    }

    protected NotificationStrategy getNotificationStrategy() {
        return this.notificationStrategy;
    }

    private List<IMMessageTarget> getNotificationTargets() {
        return this.targets;
    }

    public final String getTargets() {
        StringBuilder sb = new StringBuilder();
        for (IMMessageTarget t : this.targets) {
            if (t instanceof GroupChatIMMessageTarget && !t.toString().contains("@conference.")) {
                sb.append("*");
            }
            sb.append(t.toString());
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    public final String getStrategy() {
        return this.getNotificationStrategy().getDisplayName();
    }

    public final boolean getNotifyOnStart() {
        return this.notifyOnBuildStart;
    }

    public final boolean getNotifySuspects() {
        return this.notifySuspects;
    }

    public final boolean getNotifyFixers() {
        return this.notifyFixers;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener buildListener) throws InterruptedException, IOException {
        Assert.isNotNull(build, (String)"Parameter 'build' must not be null.");
        Assert.isNotNull((Object)buildListener, (String)"Parameter 'buildListener' must not be null.");
        if (this.getNotificationStrategy().notificationWanted(build)) {
            StringBuilder sb = IMPublisher.isFix(build) ? new StringBuilder("Yippie, build fixed!\n") : new StringBuilder();
            sb.append("Project ").append(build.getProject().getName()).append(" build (").append(build.getNumber()).append("): ").append(this.getNotificationStrategy().getResultString(build)).append(" in ").append(build.getTimestampString()).append(": ").append(MessageHelper.getBuildURL(build));
            if (build.getChangeSet() != null && !build.getChangeSet().isEmptySet()) {
                boolean hasManyChangeSets = build.getChangeSet().getItems().length > 1;
                for (ChangeLogSet.Entry entry : build.getChangeSet()) {
                    sb.append("\n");
                    if (hasManyChangeSets) {
                        sb.append("* ");
                    }
                    sb.append(entry.getAuthor()).append(": ").append(entry.getMsg());
                }
            }
            String msg = sb.toString();
            for (IMMessageTarget target : this.getNotificationTargets()) {
                try {
                    buildListener.getLogger().append("Sending notification to: " + target.toString() + "\n");
                    this.getIMConnection().send(target, msg);
                }
                catch (Throwable e) {
                    buildListener.getLogger().append("There was an Error sending notification to: " + target.toString() + "\n");
                }
            }
        }
        if (this.notifySuspects && build.getResult().isWorseThan(Result.SUCCESS)) {
            LOGGER.info("Notifying suspects");
            String message = "Oh no! You're suspected of having broken " + build.getProject().getName() + ": " + MessageHelper.getBuildURL(build);
            for (IMMessageTarget target : this.calculateSuspectsTargets(build.getChangeSet(), buildListener.getLogger())) {
                try {
                    buildListener.getLogger().append("Sending notification to suspect: " + target.toString() + "\n");
                    this.getIMConnection().send(target, message);
                }
                catch (Throwable e) {
                    buildListener.getLogger().append("There was an Error sending suspect notification to: " + target.toString() + "\n");
                }
            }
        }
        AbstractBuild previousBuild = this.getPreviousBuild(build);
        if (this.notifyFixers && build.getResult() == Result.SUCCESS && previousBuild != null && previousBuild.getResult().isWorseThan(Result.SUCCESS) && previousBuild.getResult() != Result.ABORTED) {
            LOGGER.info("Notifying fixers");
            String message = "Yippie! Seems you've fixed " + build.getProject().getName() + ": " + MessageHelper.getBuildURL(build);
            for (IMMessageTarget target : this.calculateSuspectsTargets(build.getChangeSet(), buildListener.getLogger())) {
                try {
                    buildListener.getLogger().append("Sending notification to fixer: " + target.toString() + "\n");
                    this.getIMConnection().send(target, message);
                }
                catch (Throwable e) {
                    buildListener.getLogger().append("There was an Error sending fixer notification to: " + target.toString() + "\n");
                }
            }
        }
        return true;
    }

    private static boolean isFix(AbstractBuild<?, ?> build) {
        if (build.getResult() != Result.SUCCESS) {
            return false;
        }
        for (AbstractBuild previousBuild = (AbstractBuild)build.getPreviousBuild(); previousBuild != null; previousBuild = (AbstractBuild)previousBuild.getPreviousBuild()) {
            if (previousBuild.getResult() != Result.FAILURE && previousBuild.getResult() != Result.UNSTABLE) continue;
            return true;
        }
        return false;
    }

    private AbstractBuild<?, ?> getPreviousBuild(AbstractBuild<?, ?> build) {
        AbstractBuild previousBuild = (AbstractBuild)build.getPreviousBuild();
        while (previousBuild != null) {
            if (previousBuild.getResult() == Result.ABORTED || previousBuild.getResult() == Result.NOT_BUILT) continue;
            return previousBuild;
        }
        return previousBuild;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener buildListener) {
        try {
            if (this.notifyOnBuildStart) {
                StringBuilder sb = new StringBuilder("Starting build ").append(build.getNumber()).append(" for job ").append(build.getProject().getName());
                if (build.getPreviousBuild() != null) {
                    sb.append(" (previous build: ").append(((AbstractBuild)build.getPreviousBuild()).getResult().toString().toLowerCase());
                    if (((AbstractBuild)build.getPreviousBuild()).getResult().isWorseThan(Result.SUCCESS)) {
                        sb.append(" -- last ").append(((AbstractBuild)build.getPreviousNotFailedBuild()).getResult().toString().toLowerCase()).append(" #").append(((AbstractBuild)build.getPreviousNotFailedBuild()).getNumber()).append(" ").append(((AbstractBuild)build.getPreviousNotFailedBuild()).getTimestampString()).append(" ago");
                    }
                    sb.append(")");
                }
                String msg = sb.toString();
                for (IMMessageTarget target : this.getNotificationTargets()) {
                    if (!(target instanceof GroupChatIMMessageTarget)) continue;
                    try {
                        this.getIMConnection().send(target, msg);
                    }
                    catch (Throwable e) {
                        buildListener.getLogger().append("There was an Error sending notification to: " + target.toString() + "\n");
                    }
                }
            }
        }
        catch (Throwable t) {
            buildListener.getLogger().append("There was an Error in the Jabber plugin: " + t.toString() + "\n");
        }
        return true;
    }

    private Collection<IMMessageTarget> calculateSuspectsTargets(ChangeLogSet<? extends ChangeLogSet.Entry> changeLogSet, PrintStream logger) {
        HashSet<IMMessageTarget> suspects = new HashSet<IMMessageTarget>();
        String defaultSuffix = null;
        try {
            defaultSuffix = this.getIMConnection().getDefaultIdSuffix();
            if (StringUtils.isBlank((String)defaultSuffix)) {
                defaultSuffix = null;
            }
        }
        catch (IMException e) {
            // empty catch block
        }
        LOGGER.info("Default Suffix: " + defaultSuffix);
        if (changeLogSet != null && !changeLogSet.isEmptySet()) {
            for (ChangeLogSet.Entry e : changeLogSet) {
                LOGGER.info("Possible target: " + e.getAuthor().getId() + " " + e.getAuthor().getDisplayName());
                String jabberId = null;
                JabberUserProperty jabberUserProperty = (JabberUserProperty)e.getAuthor().getProperties().get(JabberUserProperty.DESCRIPTOR);
                if (jabberUserProperty != null && jabberUserProperty.getJid() != null) {
                    jabberId = jabberUserProperty.getJid();
                } else if (defaultSuffix != null) {
                    jabberId = e.getAuthor().getId() + defaultSuffix;
                }
                if (jabberId == null) continue;
                try {
                    suspects.add(CONVERTER.fromString(jabberId));
                }
                catch (IMMessageTargetConversionException dontCare) {
                    logger.append("Invalid Jabber ID: " + jabberId + "\n");
                }
            }
        }
        return suspects;
    }
}

