/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.jabber.im.GroupChatIMMessageTarget;
import hudson.plugins.jabber.im.IMConnection;
import hudson.plugins.jabber.im.IMException;
import hudson.plugins.jabber.im.IMMessageTarget;
import hudson.plugins.jabber.im.IMPresence;
import hudson.plugins.jabber.im.transport.JabberChat;
import hudson.plugins.jabber.im.transport.JabberIMConnection;
import hudson.plugins.jabber.im.transport.JabberPublisherDescriptor;
import hudson.plugins.jabber.im.transport.bot.Bot;
import hudson.plugins.jabber.tools.Assert;
import hudson.plugins.jabber.tools.ExceptionHelper;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SSLXMPPConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.ToContainsFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;

/*
 * Exception performing whole class analysis ignored.
 */
class JabberIMConnection
implements IMConnection {
    private static final Logger LOGGER = Logger.getLogger(JabberIMConnection.class.getName());
    private volatile XMPPConnection connection;
    private final Object connectionLock = new Object();
    private final Map<String, WeakReference<GroupChat>> groupChatCache = new HashMap();
    private final Map<String, WeakReference<Chat>> chatCache = new HashMap();
    private final String passwd;
    private final String botCommandPrefix;
    private final String nick;
    private final String groupChatNick;
    private final String hostname;
    private final int port;
    private final boolean legacySSL;
    private final String[] groupChats;
    private IMPresence impresence;
    private final Connector connector;
    private final Thread connectorThread;
    private final String defaultIdSuffix;

    JabberIMConnection(JabberPublisherDescriptor desc) throws IMException {
        Assert.isNotNull((Object)desc, (String)"Parameter 'desc' must not be null.");
        this.hostname = desc.getHostname();
        this.port = desc.getPort();
        this.legacySSL = desc.isLegacySSL();
        this.nick = desc.getHudsonNickname();
        this.passwd = desc.getHudsonPassword();
        this.groupChatNick = desc.getGroupChatNickname() != null ? desc.getGroupChatNickname() : this.nick;
        this.botCommandPrefix = desc.getCommandPrefix();
        this.groupChats = desc.getInitialGroupChats() != null ? desc.getInitialGroupChats().trim().split("\\s") : new String[0];
        this.impresence = desc.isExposePresence() ? IMPresence.AVAILABLE : IMPresence.UNAVAILABLE;
        this.defaultIdSuffix = desc.getDefaultIdSuffix();
        this.connector = new Connector(this, null);
        this.connectAll();
        this.connectorThread = new Thread((Runnable)this.connector, "Jabber-ConnectorThread");
        this.connectorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectAll() {
        Object object = this.connectionLock;
        synchronized (object) {
            try {
                if (!this.isConnected()) {
                    if (this.createConnection()) {
                        LOGGER.info("Connected to XMPP on " + this.hostname + ":" + this.port);
                        for (String groupChatName : this.groupChats) {
                            try {
                                groupChatName = groupChatName.trim();
                                this.createGroupChatConnection(groupChatName, true);
                                LOGGER.info("Joined groupchat " + groupChatName);
                            }
                            catch (XMPPException e) {
                                LOGGER.warning("Unable to connect to groupchat '" + groupChatName + "'. Did you append @conference or so to the name?\n" + "Message: " + e.toString());
                            }
                        }
                        this.sendPresence();
                    } else {
                        return false;
                    }
                }
                return true;
            }
            catch (Exception dontCare) {
                LOGGER.warning(ExceptionHelper.dump((Throwable)dontCare));
                Connector.access$100((Connector)this.connector).release();
                return false;
            }
        }
    }

    public String getServiceName() {
        int idx = this.nick.indexOf(64);
        if (idx < 0) {
            return null;
        }
        return this.nick.substring(idx + 1);
    }

    public String getUserName() {
        int idx = this.nick.indexOf(64);
        if (idx < 0) {
            return this.nick;
        }
        return this.nick.substring(0, idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.connectorThread.interrupt();
        Object object = this.connectionLock;
        synchronized (object) {
            try {
                if (this.isConnected()) {
                    for (WeakReference entry : this.groupChatCache.values()) {
                        GroupChat chat = (GroupChat)entry.get();
                        if (chat == null || !chat.isJoined()) continue;
                        chat.leave();
                    }
                    this.connection.close();
                }
            }
            finally {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createConnection() throws XMPPException {
        Object object = this.connectionLock;
        synchronized (object) {
            String serviceName;
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            if ((serviceName = this.getServiceName()) == null) {
                this.connection = this.legacySSL ? new SSLXMPPConnection(this.hostname, this.port) : new XMPPConnection(this.hostname, this.port);
            } else if (this.hostname == null) {
                this.connection = this.legacySSL ? new SSLXMPPConnection(serviceName) : new XMPPConnection(serviceName);
            } else {
                Object object2 = this.connection = this.legacySSL ? new SSLXMPPConnection(this.hostname, this.port, serviceName) : new XMPPConnection(this.hostname, this.port, serviceName);
            }
            if (this.connection.isConnected()) {
                this.connection.login(this.getUserName(), this.passwd, "Hudson");
                String fullUser = this.getUserName() + "@" + this.hostname;
                AndFilter filter = new AndFilter((PacketFilter)new MessageTypeFilter(Message.Type.CHAT), (PacketFilter)new ToContainsFilter(fullUser));
                IMListener listener = new IMListener(this, null);
                this.connection.addPacketListener((PacketListener)listener, (PacketFilter)filter);
                this.connection.addConnectionListener((ConnectionListener)new /* Unavailable Anonymous Inner Class!! */);
            }
            return this.connection.isAuthenticated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroupChat createGroupChatConnection(String groupChatName, boolean forceReconnect) throws XMPPException {
        Object object = this.connectionLock;
        synchronized (object) {
            boolean create;
            WeakReference ref = (WeakReference)this.groupChatCache.get(groupChatName);
            GroupChat groupChat = null;
            if (ref != null) {
                groupChat = (GroupChat)ref.get();
            }
            boolean bl = create = ref == null || groupChat == null || forceReconnect;
            if (forceReconnect && groupChat != null) {
                try {
                    this.groupChatCache.remove(groupChat);
                    groupChat.leave();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (create) {
                groupChat = this.connection.createGroupChat(groupChatName);
                groupChat.join(this.groupChatNick);
                while (groupChat.pollMessage() != null) {
                }
                Bot bot = new Bot((JabberChat)new JabberChat.MultiUserChat(groupChat), this.groupChatNick, this.hostname, this.botCommandPrefix);
                this.groupChatCache.put(groupChatName, new WeakReference<GroupChat>(groupChat));
                groupChat.addMessageListener((PacketListener)bot);
            }
            return groupChat;
        }
    }

    private Chat getChat(String chatPartner, Message msg) {
        Chat c;
        WeakReference wr = (WeakReference)this.chatCache.get(chatPartner);
        if (wr != null && (c = (Chat)wr.get()) != null) {
            return c;
        }
        Chat chat = this.connection.createChat(chatPartner);
        Bot bot = new Bot((JabberChat)new JabberChat.SingleChat(chat), this.groupChatNick, this.hostname, this.botCommandPrefix);
        if (msg != null) {
            bot.processPacket((Packet)msg);
        }
        chat.addMessageListener((PacketListener)bot);
        this.chatCache.put(chatPartner, new WeakReference<Chat>(chat));
        return chat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(IMMessageTarget target, String text) throws IMException {
        Assert.isNotNull((Object)target, (String)"Parameter 'target' must not be null.");
        Assert.isNotNull((Object)text, (String)"Parameter 'text' must not be null.");
        try {
            Object object = this.connectionLock;
            synchronized (object) {
                if (target instanceof GroupChatIMMessageTarget) {
                    this.createGroupChatConnection(target.toString(), false).sendMessage(text);
                } else {
                    Chat chat = this.getChat(target.toString(), null);
                    chat.sendMessage(text);
                }
            }
        }
        catch (XMPPException dontCare) {
            dontCare.printStackTrace();
            Connector.access$100((Connector)this.connector).release();
        }
    }

    public void setPresence(IMPresence impresence) throws IMException {
        Assert.isNotNull((Object)impresence, (String)"Parameter 'impresence' must not be null.");
        this.impresence = impresence;
        this.sendPresence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPresence() {
        Object object = this.connectionLock;
        synchronized (object) {
            Presence presence;
            if (!this.isConnected()) {
                return;
            }
            switch (2.$SwitchMap$hudson$plugins$jabber$im$IMPresence[this.impresence.ordinal()]) {
                case 1: {
                    presence = new Presence(Presence.Type.AVAILABLE, "", 1, Presence.Mode.AVAILABLE);
                    break;
                }
                case 2: {
                    presence = new Presence(Presence.Type.UNAVAILABLE);
                    break;
                }
                default: {
                    throw new IllegalStateException("Don't know how to handle " + this.impresence);
                }
            }
            this.connection.sendPacket((Packet)presence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConnected() {
        Object object = this.connectionLock;
        synchronized (object) {
            return this.connection != null && this.connection.isAuthenticated();
        }
    }

    public String getDefaultIdSuffix() {
        return this.defaultIdSuffix;
    }

    static /* synthetic */ Connector access$300(JabberIMConnection x0) {
        return x0.connector;
    }

    static /* synthetic */ Logger access$400() {
        return LOGGER;
    }

    static /* synthetic */ Chat access$500(JabberIMConnection x0, String x1, Message x2) {
        return x0.getChat(x1, x2);
    }

    static /* synthetic */ Object access$600(JabberIMConnection x0) {
        return x0.connectionLock;
    }

    static /* synthetic */ boolean access$700(JabberIMConnection x0) {
        return x0.isConnected();
    }

    static /* synthetic */ boolean access$800(JabberIMConnection x0) {
        return x0.connectAll();
    }
}

