/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport.bot;

import hudson.plugins.jabber.im.transport.JabberChat;
import hudson.plugins.jabber.im.transport.bot.AbortCommand;
import hudson.plugins.jabber.im.transport.bot.BotCommand;
import hudson.plugins.jabber.im.transport.bot.BuildCommand;
import hudson.plugins.jabber.im.transport.bot.HealthCommand;
import hudson.plugins.jabber.im.transport.bot.QueueCommand;
import hudson.plugins.jabber.im.transport.bot.SnackCommand;
import hudson.plugins.jabber.im.transport.bot.StatusCommand;
import hudson.plugins.jabber.im.transport.bot.TestResultCommand;
import hudson.plugins.jabber.tools.MessageHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.packet.DelayInformation;

/*
 * Exception performing whole class analysis ignored.
 */
public class Bot
implements PacketListener {
    private static final Logger LOGGER = Logger.getLogger(Bot.class.getName());
    private final BotCommand BUILD_COMMAND;
    private static final BotCommand STATUS_COMMAND = new StatusCommand();
    private static final BotCommand HEALTH_COMMAND = new HealthCommand();
    private static final BotCommand QUEUE_COMMAND = new QueueCommand();
    private static final BotCommand SNACK_COMMAND = new SnackCommand();
    private static final BotCommand TESTRESULTS_COMMAND = new TestResultCommand();
    private static final BotCommand ABORT_COMMAND = new AbortCommand();
    private static final BotCommand HELP_COMMAND = new /* Unavailable Anonymous Inner Class!! */;
    private static String HELP_CACHE = null;
    private static final Map<String, BotCommand> COMMAND_MAP = new HashMap();
    private final JabberChat chat;
    private final String nick;
    private final String jabberServer;
    private final String commandPrefix;

    public Bot(JabberChat chat, String nick, String jabberServer, String commandPrefix) {
        this.chat = chat;
        this.nick = nick;
        this.jabberServer = jabberServer;
        this.commandPrefix = commandPrefix;
        this.BUILD_COMMAND = new BuildCommand(this.nick + "@" + this.jabberServer);
        COMMAND_MAP.put("build", this.BUILD_COMMAND);
        COMMAND_MAP.put("schedule", this.BUILD_COMMAND);
    }

    public void processPacket(Packet p) {
        if (p instanceof Message) {
            String[] args;
            Iterator iter = p.getExtensions();
            while (iter.hasNext()) {
                PacketExtension pe = (PacketExtension)iter.next();
                if (!(pe instanceof DelayInformation)) continue;
                return;
            }
            Message msg = (Message)p;
            String payload = this.retrieveMessagePayLoad(msg.getBody());
            if (payload != null && (args = MessageHelper.extractCommandLine((String)payload)).length > 0) {
                String cmd = args[0];
                String sender = msg.getFrom();
                if (sender != null) {
                    sender = this.chat.getNickName(sender);
                }
                try {
                    if (COMMAND_MAP.containsKey(cmd)) {
                        BotCommand command = (BotCommand)COMMAND_MAP.get(cmd);
                        command.executeCommand(this.chat, msg, sender, args);
                    } else {
                        this.chat.sendMessage(sender + " did you mean me? Unknown command '" + cmd + "'\nUse " + this.commandPrefix + "help to get help!");
                    }
                }
                catch (XMPPException e) {
                    LOGGER.warning(e.toString());
                }
            }
        }
    }

    private static boolean isNickSeparator(String candidate) {
        return ":".equals(candidate) || ",".equals(candidate);
    }

    private String retrieveMessagePayLoad(String body) {
        if (body == null) {
            return null;
        }
        if (body.startsWith(this.commandPrefix)) {
            return body.substring(this.commandPrefix.length()).trim();
        }
        if (body.startsWith(this.nick) && Bot.isNickSeparator((String)body.substring(this.nick.length(), this.nick.length() + 1))) {
            return body.substring(this.nick.length() + 1).trim();
        }
        return null;
    }

    static /* synthetic */ String access$000() {
        return HELP_CACHE;
    }

    static /* synthetic */ Map access$100() {
        return COMMAND_MAP;
    }

    static /* synthetic */ String access$002(String x0) {
        HELP_CACHE = x0;
        return HELP_CACHE;
    }

    static {
        COMMAND_MAP.put("help", HELP_COMMAND);
        COMMAND_MAP.put("status", STATUS_COMMAND);
        COMMAND_MAP.put("s", STATUS_COMMAND);
        COMMAND_MAP.put("health", HEALTH_COMMAND);
        COMMAND_MAP.put("h", HEALTH_COMMAND);
        COMMAND_MAP.put("jobs", STATUS_COMMAND);
        COMMAND_MAP.put("queue", QUEUE_COMMAND);
        COMMAND_MAP.put("q", QUEUE_COMMAND);
        COMMAND_MAP.put("testresult", TESTRESULTS_COMMAND);
        COMMAND_MAP.put("abort", ABORT_COMMAND);
        COMMAND_MAP.put("botsnack", SNACK_COMMAND);
    }
}

