/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.jabber.tools.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NotificationStrategy {
    ALL("all"){

        @Override
        public boolean notificationWanted(AbstractBuild<?, ?> build) {
            return true;
        }
    }
    ,
    ANY_FAILURE("failure"){

        @Override
        public boolean notificationWanted(AbstractBuild<?, ?> build) {
            Assert.isNotNull(build, "Parameter 'build' must not be null.");
            return build.getResult() != Result.SUCCESS;
        }
    }
    ,
    FAILURE_AND_FIXED("failure and fixed"){

        @Override
        public boolean notificationWanted(AbstractBuild<?, ?> build) {
            Assert.isNotNull(build, "Parameter 'build' must not be null.");
            if (build.getResult() != Result.SUCCESS) {
                return true;
            }
            AbstractBuild previousBuild = (AbstractBuild)build.getPreviousBuild();
            if (previousBuild == null) {
                return false;
            }
            return previousBuild.getResult() != Result.SUCCESS;
        }

        @Override
        public String getResultString(AbstractBuild<?, ?> build) {
            if (build.getResult() != Result.SUCCESS) {
                return build.getResult().toString();
            }
            AbstractBuild previousBuild = (AbstractBuild)build.getPreviousBuild();
            if (previousBuild != null && previousBuild.getResult().isWorseThan(Result.SUCCESS)) {
                return "FIXED";
            }
            return build.getResult().toString();
        }
    }
    ,
    STATECHANGE_ONLY("change"){

        @Override
        public boolean notificationWanted(AbstractBuild<?, ?> build) {
            Assert.isNotNull(build, "Parameter 'build' must not be null.");
            AbstractBuild previousBuild = (AbstractBuild)build.getPreviousBuild();
            return previousBuild == null || build.getResult() != previousBuild.getResult();
        }
    };

    private final String displayName;

    private NotificationStrategy(String displayName) {
        this.displayName = displayName;
    }

    public abstract boolean notificationWanted(AbstractBuild<?, ?> var1);

    public String getResultString(AbstractBuild<?, ?> build) {
        return build.getResult().toString();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static NotificationStrategy forDisplayName(String displayName) {
        for (NotificationStrategy strategy : NotificationStrategy.values()) {
            if (!strategy.getDisplayName().equals(displayName)) continue;
            return strategy;
        }
        return null;
    }
}

