/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.XMPPException;

public interface JabberChat {
    public void sendMessage(String var1) throws XMPPException;

    public String getNickName(String var1);

    public static class SingleChat
    implements JabberChat {
        private Chat chat;

        public SingleChat(Chat chat) {
            this.chat = chat;
        }

        public void sendMessage(String msg) throws XMPPException {
            this.chat.sendMessage(msg);
        }

        public String getNickName(String sender) {
            String s = sender;
            int index = s.indexOf(47);
            if (index != -1) {
                s = s.substring(0, index);
            }
            if ((index = s.indexOf(64)) != -1) {
                s = s.substring(0, index);
            }
            return s;
        }
    }

    public static class MultiUserChat
    implements JabberChat {
        private GroupChat chat;

        public MultiUserChat(GroupChat chat) {
            this.chat = chat;
        }

        public void sendMessage(String msg) throws XMPPException {
            this.chat.sendMessage(msg);
        }

        public String getNickName(String sender) {
            int slashIndex = sender.indexOf(47);
            if (slashIndex != -1) {
                sender = sender.substring(slashIndex + 1);
            }
            return sender;
        }
    }
}

