/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.jabber.im.GroupChatIMMessageTarget;
import hudson.plugins.jabber.im.IMConnection;
import hudson.plugins.jabber.im.IMException;
import hudson.plugins.jabber.im.IMMessageTarget;
import hudson.plugins.jabber.im.IMPresence;
import hudson.plugins.jabber.im.transport.JabberChat;
import hudson.plugins.jabber.im.transport.JabberPublisherDescriptor;
import hudson.plugins.jabber.im.transport.bot.Bot;
import hudson.plugins.jabber.tools.Assert;
import hudson.plugins.jabber.tools.ExceptionHelper;
import hudson.util.TimeUnit2;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SSLXMPPConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.ToContainsFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.jivesoftware.smackx.packet.MessageEvent;
import org.jivesoftware.smackx.packet.XHTMLExtension;

class JabberIMConnection
implements IMConnection {
    private static final Logger LOGGER = Logger.getLogger(JabberIMConnection.class.getName());
    private volatile XMPPConnection connection;
    private final Object connectionLock = new Object();
    private final Map<String, WeakReference<GroupChat>> groupChatCache = new HashMap<String, WeakReference<GroupChat>>();
    private final Map<String, WeakReference<Chat>> chatCache = new HashMap<String, WeakReference<Chat>>();
    private final String passwd;
    private final String botCommandPrefix;
    private final String nick;
    private final String groupChatNick;
    private final String hostname;
    private final int port;
    private final boolean legacySSL;
    private final String[] groupChats;
    private IMPresence impresence;
    private final Connector connector;
    private final Thread connectorThread;
    private final String defaultIdSuffix;

    JabberIMConnection(JabberPublisherDescriptor desc) throws IMException {
        Assert.isNotNull((Object)desc, "Parameter 'desc' must not be null.");
        this.hostname = desc.getHostname();
        this.port = desc.getPort();
        this.legacySSL = desc.isLegacySSL();
        this.nick = desc.getHudsonNickname();
        this.passwd = desc.getHudsonPassword();
        this.groupChatNick = desc.getGroupChatNickname() != null ? desc.getGroupChatNickname() : this.nick;
        this.botCommandPrefix = desc.getCommandPrefix();
        this.groupChats = desc.getInitialGroupChats() != null ? desc.getInitialGroupChats().trim().split("\\s") : new String[0];
        this.impresence = desc.isExposePresence() ? IMPresence.AVAILABLE : IMPresence.UNAVAILABLE;
        this.defaultIdSuffix = desc.getDefaultIdSuffix();
        this.connector = new Connector();
        this.connectAll();
        this.connectorThread = new Thread((Runnable)this.connector, "Jabber-ConnectorThread");
        this.connectorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectAll() {
        Object object = this.connectionLock;
        synchronized (object) {
            try {
                if (!this.isConnected()) {
                    if (this.createConnection()) {
                        LOGGER.info("Connected to XMPP on " + this.hostname + ":" + this.port);
                        for (String groupChatName : this.groupChats) {
                            try {
                                groupChatName = groupChatName.trim();
                                this.createGroupChatConnection(groupChatName, true);
                                LOGGER.info("Joined groupchat " + groupChatName);
                            }
                            catch (XMPPException e) {
                                LOGGER.warning("Unable to connect to groupchat '" + groupChatName + "'. Did you append @conference or so to the name?\n" + "Message: " + e.toString());
                            }
                        }
                        this.sendPresence();
                    } else {
                        return false;
                    }
                }
                return true;
            }
            catch (Exception dontCare) {
                LOGGER.warning(ExceptionHelper.dump(dontCare));
                this.connector.semaphore.release();
                return false;
            }
        }
    }

    public String getServiceName() {
        int idx = this.nick.indexOf(64);
        if (idx < 0) {
            return null;
        }
        return this.nick.substring(idx + 1);
    }

    public String getUserName() {
        int idx = this.nick.indexOf(64);
        if (idx < 0) {
            return this.nick;
        }
        return this.nick.substring(0, idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.connectorThread.interrupt();
        Object object = this.connectionLock;
        synchronized (object) {
            try {
                if (this.isConnected()) {
                    for (WeakReference<GroupChat> entry : this.groupChatCache.values()) {
                        GroupChat chat = (GroupChat)entry.get();
                        if (chat == null || !chat.isJoined()) continue;
                        chat.leave();
                    }
                    this.connection.close();
                }
            }
            finally {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createConnection() throws XMPPException {
        Object object = this.connectionLock;
        synchronized (object) {
            String serviceName;
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            if ((serviceName = this.getServiceName()) == null) {
                this.connection = this.legacySSL ? new SSLXMPPConnection(this.hostname, this.port) : new XMPPConnection(this.hostname, this.port);
            } else if (this.hostname == null) {
                this.connection = this.legacySSL ? new SSLXMPPConnection(serviceName) : new XMPPConnection(serviceName);
            } else {
                Object object2 = this.connection = this.legacySSL ? new SSLXMPPConnection(this.hostname, this.port, serviceName) : new XMPPConnection(this.hostname, this.port, serviceName);
            }
            if (this.connection.isConnected()) {
                this.connection.login(this.getUserName(), this.passwd, "Hudson");
                String fullUser = this.getUserName() + "@" + this.hostname;
                AndFilter filter = new AndFilter((PacketFilter)new MessageTypeFilter(Message.Type.CHAT), (PacketFilter)new ToContainsFilter(fullUser));
                IMListener listener = new IMListener();
                this.connection.addPacketListener((PacketListener)listener, (PacketFilter)filter);
                this.connection.addConnectionListener(new ConnectionListener(){

                    public void connectionClosedOnError(Exception paramException) {
                        JabberIMConnection.this.connector.semaphore.release();
                    }

                    public void connectionClosed() {
                        JabberIMConnection.this.connector.semaphore.release();
                    }
                });
            }
            return this.connection.isAuthenticated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroupChat createGroupChatConnection(String groupChatName, boolean forceReconnect) throws XMPPException {
        Object object = this.connectionLock;
        synchronized (object) {
            boolean create;
            WeakReference<GroupChat> ref = this.groupChatCache.get(groupChatName);
            GroupChat groupChat = null;
            if (ref != null) {
                groupChat = (GroupChat)ref.get();
            }
            boolean bl = create = ref == null || groupChat == null || forceReconnect;
            if (forceReconnect && groupChat != null) {
                try {
                    this.groupChatCache.remove(groupChat);
                    groupChat.leave();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (create) {
                groupChat = this.connection.createGroupChat(groupChatName);
                groupChat.join(this.groupChatNick);
                while (groupChat.pollMessage() != null) {
                }
                Bot bot = new Bot(new JabberChat.MultiUserChat(groupChat), this.groupChatNick, this.hostname, this.botCommandPrefix);
                this.groupChatCache.put(groupChatName, new WeakReference<GroupChat>(groupChat));
                groupChat.addMessageListener((PacketListener)bot);
            }
            return groupChat;
        }
    }

    private Chat getChat(String chatPartner, Message msg) {
        Chat c;
        WeakReference<Chat> wr = this.chatCache.get(chatPartner);
        if (wr != null && (c = (Chat)wr.get()) != null) {
            return c;
        }
        Chat chat = this.connection.createChat(chatPartner);
        Bot bot = new Bot(new JabberChat.SingleChat(chat), this.groupChatNick, this.hostname, this.botCommandPrefix);
        if (msg != null) {
            bot.processPacket((Packet)msg);
        }
        chat.addMessageListener((PacketListener)bot);
        this.chatCache.put(chatPartner, new WeakReference<Chat>(chat));
        return chat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(IMMessageTarget target, String text) throws IMException {
        Assert.isNotNull(target, "Parameter 'target' must not be null.");
        Assert.isNotNull(text, "Parameter 'text' must not be null.");
        try {
            Object object = this.connectionLock;
            synchronized (object) {
                if (target instanceof GroupChatIMMessageTarget) {
                    this.createGroupChatConnection(target.toString(), false).sendMessage(text);
                } else {
                    Chat chat = this.getChat(target.toString(), null);
                    chat.sendMessage(text);
                }
            }
        }
        catch (XMPPException dontCare) {
            dontCare.printStackTrace();
            this.connector.semaphore.release();
        }
    }

    public void setPresence(IMPresence impresence) throws IMException {
        Assert.isNotNull((Object)impresence, "Parameter 'impresence' must not be null.");
        this.impresence = impresence;
        this.sendPresence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPresence() {
        Object object = this.connectionLock;
        synchronized (object) {
            Presence presence;
            if (!this.isConnected()) {
                return;
            }
            switch (this.impresence) {
                case AVAILABLE: {
                    presence = new Presence(Presence.Type.AVAILABLE, "", 1, Presence.Mode.AVAILABLE);
                    break;
                }
                case UNAVAILABLE: {
                    presence = new Presence(Presence.Type.UNAVAILABLE);
                    break;
                }
                default: {
                    throw new IllegalStateException("Don't know how to handle " + (Object)((Object)this.impresence));
                }
            }
            this.connection.sendPacket((Packet)presence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConnected() {
        Object object = this.connectionLock;
        synchronized (object) {
            return this.connection != null && this.connection.isAuthenticated();
        }
    }

    public String getDefaultIdSuffix() {
        return this.defaultIdSuffix;
    }

    private final class Connector
    implements Runnable {
        private final Semaphore semaphore = new Semaphore(0);

        private Connector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                block5: while (true) {
                    this.semaphore.acquire();
                    this.semaphore.drainPermits();
                    LOGGER.info("Trying to reconnect");
                    TimeUnit.SECONDS.sleep(30L);
                    boolean success = false;
                    int timeout = 1;
                    while (true) {
                        if (success) continue block5;
                        Object object = JabberIMConnection.this.connectionLock;
                        synchronized (object) {
                            success = !JabberIMConnection.this.isConnected() ? JabberIMConnection.this.connectAll() : true;
                        }
                        if (success) continue;
                        LOGGER.info("Reconnect failed. Next connection attempt in " + timeout + " minutes");
                        TimeUnit2.MINUTES.sleep((long)timeout);
                        timeout *= 2;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                LOGGER.info("Connect thread interrupted");
                return;
            }
        }
    }

    private final class IMListener
    implements PacketListener {
        private IMListener() {
        }

        public void processPacket(Packet packet) {
            if (packet instanceof Message) {
                Message m = (Message)packet;
                boolean composing = false;
                boolean xhtmlMessage = false;
                Iterator extensions = m.getExtensions();
                while (extensions.hasNext()) {
                    MessageEvent me;
                    PacketExtension ext = (PacketExtension)extensions.next();
                    if (ext instanceof DelayInformation) {
                        return;
                    }
                    if (ext instanceof MessageEvent && (me = (MessageEvent)ext).isComposing()) {
                        composing = true;
                    }
                    if (!(ext instanceof XHTMLExtension)) continue;
                    xhtmlMessage = true;
                }
                if (composing && !xhtmlMessage) {
                    return;
                }
                if (m.getBody() != null) {
                    LOGGER.info("Message from " + m.getFrom() + " : " + m.getBody());
                    String chatPartner = m.getFrom();
                    JabberIMConnection.this.getChat(chatPartner, m);
                }
            }
        }
    }
}

