/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport.bot;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.model.Queue;
import hudson.plugins.jabber.im.transport.JabberChat;
import hudson.plugins.jabber.im.transport.bot.BotCommand;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;

public class AbortCommand
implements BotCommand {
    private static final String HELP = " <job> - specify which job to abort";

    public void executeCommand(JabberChat groupChat, Message message, String sender, String[] args) throws XMPPException {
        if (args.length >= 2) {
            String jobName = args[1];
            jobName = jobName.replaceAll("\"", "");
            AbstractProject project = (AbstractProject)Hudson.getInstance().getItemByFullName(jobName, AbstractProject.class);
            if (project == null) {
                groupChat.sendMessage(sender + ": that doesn't look like a valid job");
                return;
            }
            if (!project.isInQueue() && !project.isBuilding()) {
                groupChat.sendMessage(String.format("%s: how do you intend a build that isn't building?", sender));
                return;
            }
            boolean aborted = false;
            if (project.isInQueue()) {
                aborted = Hudson.getInstance().getQueue().cancel((Queue.Task)project);
            }
            if (!aborted) {
                AbstractBuild build = (AbstractBuild)project.getLastBuild();
                if (build == null) {
                    groupChat.sendMessage(sender + ": it appears this job has never been built");
                    return;
                }
                Executor ex = build.getExecutor();
                if (ex == null) {
                    aborted = false;
                } else {
                    ex.interrupt();
                }
            }
            if (aborted) {
                groupChat.sendMessage(jobName + " aborted, I hope you're happy!");
            } else {
                groupChat.sendMessage(sender + ": " + " couldn't abort " + jobName + ". I don't know why this happened.");
            }
        } else {
            groupChat.sendMessage(sender + ": you need to specify a job name");
            return;
        }
    }

    public String getHelp() {
        return HELP;
    }
}

