/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport.bot;

import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.Hudson;
import hudson.model.Queue;
import hudson.plugins.jabber.im.transport.JabberChat;
import hudson.plugins.jabber.im.transport.bot.BotCommand;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildCommand
implements BotCommand {
    private static final Pattern NUMERIC_EXTRACTION_REGEX = Pattern.compile("^(\\d+)");
    private static final String SYNTAX = " <job> [now|<delay[s|m|h]>]";
    private static final String HELP = " <job> [now|<delay[s|m|h]>] - schedule a job build, with standard, custom or no quiet period";
    private final String jabberId;

    public BuildCommand(String jabberId) {
        this.jabberId = jabberId;
    }

    private boolean scheduleBuild(AbstractProject<?, ?> project, int delaySeconds, String sender) {
        Cause.RemoteCause cause = new Cause.RemoteCause(this.jabberId, "on request of '" + sender + "'");
        return project.scheduleBuild(delaySeconds, (Cause)cause);
    }

    @Override
    public void executeCommand(JabberChat groupChat, Message message, String sender, String[] args) throws XMPPException {
        if (args.length >= 2) {
            String jobName = args[1];
            jobName = jobName.replaceAll("\"", "");
            AbstractProject project = (AbstractProject)Hudson.getInstance().getItemByFullName(jobName, AbstractProject.class);
            if (project != null) {
                if (project.isInQueue()) {
                    Queue.Item queueItem = project.getQueueItem();
                    groupChat.sendMessage(sender + ": job " + jobName + " is already in the build queue (" + queueItem.getWhy() + ")");
                } else if (project.isDisabled()) {
                    groupChat.sendMessage(sender + ": job " + jobName + " is disabled");
                } else if (args.length == 2 || args.length == 3 && "now".equalsIgnoreCase(args[2])) {
                    if (this.scheduleBuild(project, 1, sender)) {
                        groupChat.sendMessage(sender + ": job " + jobName + " build scheduled now");
                    } else {
                        groupChat.sendMessage(sender + ": job " + jobName + " scheduling failed or already in build queue");
                    }
                } else if (args.length >= 3) {
                    String delay = args[2].trim();
                    int factor = 1;
                    if (delay.endsWith("m") || delay.endsWith("min")) {
                        factor = 60;
                    } else if (delay.endsWith("h")) {
                        factor = 3600;
                    } else {
                        char c = delay.charAt(delay.length() - 1);
                        if (c != 's' && !Character.isDigit(c)) {
                            this.giveSyntax(groupChat, sender, args[0]);
                            return;
                        }
                    }
                    Matcher matcher = NUMERIC_EXTRACTION_REGEX.matcher(delay);
                    if (matcher.find()) {
                        int value = Integer.parseInt(matcher.group());
                        if (this.scheduleBuild(project, value * factor, sender)) {
                            groupChat.sendMessage(sender + ": job " + jobName + " build scheduled with a quiet period of " + value * factor + " seconds");
                        } else {
                            groupChat.sendMessage(sender + ": job " + jobName + " already scheduled in build queue");
                        }
                    }
                } else if (this.scheduleBuild(project, project.getQuietPeriod(), sender)) {
                    groupChat.sendMessage(sender + ": job " + jobName + " build scheduled (quiet period: " + project.getQuietPeriod() + " seconds)");
                } else {
                    groupChat.sendMessage(sender + ": job " + jobName + " already scheduled in build queue");
                }
            } else {
                this.giveSyntax(groupChat, sender, args[0]);
            }
        } else {
            groupChat.sendMessage(sender + ": Error, syntax is: '" + args[0] + SYNTAX + "'");
        }
    }

    private void giveSyntax(JabberChat chat, String sender, String cmd) throws XMPPException {
        chat.sendMessage(sender + ": syntax is: '" + cmd + SYNTAX + "'");
    }

    @Override
    public String getHelp() {
        return HELP;
    }
}

