/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMConnectionProvider;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.jabber.im.transport.JabberIMConnection;
import hudson.plugins.jabber.im.transport.JabberPublisherDescriptor;

final class JabberIMConnectionProvider
extends IMConnectionProvider {
    private static final IMConnectionProvider INSTANCE = new JabberIMConnectionProvider();

    static final synchronized IMConnectionProvider getInstance() {
        return INSTANCE;
    }

    static final synchronized void setDesc(IMPublisherDescriptor desc) throws IMException {
        INSTANCE.setDescriptor(desc);
        INSTANCE.releaseConnection();
    }

    private JabberIMConnectionProvider() {
        this.init();
    }

    public synchronized IMConnection createConnection() throws IMException {
        this.releaseConnection();
        if (this.getDescriptor() == null) {
            throw new IMException("Descriptor not set");
        }
        JabberIMConnection imConnection = new JabberIMConnection((JabberPublisherDescriptor)this.getDescriptor(), this.getAuthenticationHolder());
        if (imConnection.connect()) {
            return imConnection;
        }
        throw new IMException("Connection failed");
    }
}

