/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.im.IMMessage;
import hudson.plugins.im.IMMessageListener;
import hudson.plugins.jabber.im.transport.JabberIMConnection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.packet.DelayInformation;

class JabberMUCMessageListenerAdapter
implements PacketListener {
    private final IMMessageListener listener;
    private final JabberIMConnection connection;
    private final MultiUserChat muc;

    public JabberMUCMessageListenerAdapter(IMMessageListener listener, JabberIMConnection connection, MultiUserChat muc) {
        this.listener = listener;
        this.connection = connection;
        this.muc = muc;
    }

    public void processPacket(Packet p) {
        if (p instanceof Message) {
            for (PacketExtension pe : p.getExtensions()) {
                if (!(pe instanceof DelayInformation)) continue;
                return;
            }
            Message msg = (Message)p;
            IMMessage imMessage = new IMMessage(msg.getFrom(), msg.getTo(), msg.getBody(), true);
            this.listener.onMessage(imMessage);
        }
    }
}

