/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.model.User;
import hudson.plugins.im.GroupChatIMMessageTarget;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMMessageTargetConversionException;
import hudson.plugins.im.IMMessageTargetConverter;
import hudson.plugins.im.IMPublisher;
import hudson.plugins.im.build_notify.BuildToChatNotifier;
import hudson.plugins.jabber.im.transport.JabberIMConnectionProvider;
import hudson.plugins.jabber.im.transport.JabberPublisher;
import hudson.plugins.jabber.im.transport.JabberPublisherDescriptor;
import hudson.plugins.jabber.user.JabberUserProperty;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JabberPublisher
extends IMPublisher {
    public static final JabberPublisherDescriptor DESCRIPTOR = new JabberPublisherDescriptor();
    static final IMMessageTargetConverter CONVERTER = new JabberIMMessageTargetConverter(null);

    public JabberPublisher(List<IMMessageTarget> targets, String notificationStrategy, boolean notifyGroupChatsOnBuildStart, boolean notifySuspects, boolean notifyCulprits, boolean notifyFixers, boolean notifyUpstreamCommitters, BuildToChatNotifier buildToChatNotifier) throws IMMessageTargetConversionException {
        super(targets, notificationStrategy, notifyGroupChatsOnBuildStart, notifySuspects, notifyCulprits, notifyFixers, notifyUpstreamCommitters, buildToChatNotifier);
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    protected IMConnection getIMConnection() throws IMException {
        return JabberIMConnectionProvider.getInstance().currentConnection();
    }

    protected String getPluginName() {
        return "Jabber notifier plugin";
    }

    protected String getConfiguredIMId(User user) {
        JabberUserProperty jabberUserProperty = (JabberUserProperty)user.getProperties().get(JabberUserProperty.DESCRIPTOR);
        if (jabberUserProperty != null) {
            return jabberUserProperty.getJid();
        }
        return null;
    }

    public String getTargets() {
        List notificationTargets = this.getNotificationTargets();
        StringBuilder sb = new StringBuilder();
        for (IMMessageTarget target : notificationTargets) {
            if (target instanceof GroupChatIMMessageTarget && !target.toString().contains("@conference.")) {
                sb.append("*");
            }
            sb.append(this.getIMDescriptor().getIMMessageTargetConverter().toString(target));
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }
}

