/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingFilterWriter
extends FilterWriter {
    private final Writer wrappedWriter;
    private final Logger logger;
    private final Level level;

    public LoggingFilterWriter(Writer wrapped, Logger logger, Level level) {
        super(wrapped);
        this.wrappedWriter = wrapped;
        this.logger = logger;
        this.level = level;
    }

    private boolean isEnabled() {
        return this.logger.isLoggable(this.level);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.wrappedWriter.write(cbuf, off, len);
        if (this.isEnabled()) {
            String str = new String(cbuf, off, len);
            this.log(str);
        }
    }

    public void write(char[] cbuf) throws IOException {
        this.wrappedWriter.write(cbuf);
        if (this.isEnabled()) {
            String str = new String(cbuf);
            this.log(str);
        }
    }

    public void write(String str) throws IOException {
        this.wrappedWriter.write(str);
        this.log(str);
    }

    public void write(String str, int off, int len) throws IOException {
        this.wrappedWriter.write(str, off, len);
        if (this.isEnabled()) {
            str = str.substring(off, off + len);
            this.log(str);
        }
    }

    private void log(String str) {
        this.logger.log(this.level, "SENT: " + str);
    }
}

