/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.model.User;
import hudson.plugins.im.DefaultIMMessageTarget;
import hudson.plugins.im.GroupChatIMMessageTarget;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMMessageTargetConversionException;
import hudson.plugins.im.IMMessageTargetConverter;
import hudson.plugins.im.IMPublisher;
import hudson.plugins.im.build_notify.BuildToChatNotifier;
import hudson.plugins.im.tools.Assert;
import hudson.plugins.jabber.im.transport.JabberIMConnectionProvider;
import hudson.plugins.jabber.im.transport.JabberPublisherDescriptor;
import hudson.plugins.jabber.user.JabberUserProperty;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JabberPublisher
extends IMPublisher {
    public static final JabberPublisherDescriptor DESCRIPTOR = new JabberPublisherDescriptor();
    static final IMMessageTargetConverter CONVERTER = new JabberIMMessageTargetConverter();

    public JabberPublisher(List<IMMessageTarget> targets, String notificationStrategy, boolean notifyGroupChatsOnBuildStart, boolean notifySuspects, boolean notifyCulprits, boolean notifyFixers, boolean notifyUpstreamCommitters, BuildToChatNotifier buildToChatNotifier) throws IMMessageTargetConversionException {
        super(targets, notificationStrategy, notifyGroupChatsOnBuildStart, notifySuspects, notifyCulprits, notifyFixers, notifyUpstreamCommitters, buildToChatNotifier);
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    protected IMConnection getIMConnection() throws IMException {
        return JabberIMConnectionProvider.getInstance().currentConnection();
    }

    protected String getPluginName() {
        return "Jabber notifier plugin";
    }

    protected String getConfiguredIMId(User user) {
        JabberUserProperty jabberUserProperty = (JabberUserProperty)((Object)user.getProperties().get((Object)JabberUserProperty.DESCRIPTOR));
        if (jabberUserProperty != null) {
            return jabberUserProperty.getJid();
        }
        return null;
    }

    public String getTargets() {
        List notificationTargets = this.getNotificationTargets();
        StringBuilder sb = new StringBuilder();
        for (IMMessageTarget target : notificationTargets) {
            if (target instanceof GroupChatIMMessageTarget && !target.toString().contains("@conference.")) {
                sb.append("*");
            }
            sb.append(this.getIMDescriptor().getIMMessageTargetConverter().toString(target));
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    protected Object readResolve() {
        super.readResolve();
        return this;
    }

    private static class JabberIMMessageTargetConverter
    implements IMMessageTargetConverter {
        private JabberIMMessageTargetConverter() {
        }

        private void checkValidity(String f) throws IMMessageTargetConversionException {
            int i = f.indexOf(64);
            if (i == -1) {
                throw new IMMessageTargetConversionException("Invalid input for target: '" + f + "'." + "\nDoesn't contain a @.");
            }
            if (f.indexOf(64, i + 1) != -1) {
                throw new IMMessageTargetConversionException("Invalid input for target: '" + f + "'." + "\nContains more than on @.");
            }
        }

        public IMMessageTarget fromString(String targetAsString) throws IMMessageTargetConversionException {
            String f = targetAsString.trim();
            if (f.length() > 0) {
                GroupChatIMMessageTarget target;
                if (f.startsWith("*")) {
                    if (!(f = f.substring(1)).contains("@")) {
                        f = f + "@conference." + DESCRIPTOR.getHostname();
                    }
                    target = new GroupChatIMMessageTarget(f);
                } else if (f.contains("@conference.")) {
                    target = new GroupChatIMMessageTarget(f);
                } else {
                    if (!f.contains("@")) {
                        f = f + "@" + DESCRIPTOR.getHostname();
                    }
                    target = new DefaultIMMessageTarget(f);
                }
                this.checkValidity(f);
                return target;
            }
            return null;
        }

        public String toString(IMMessageTarget target) {
            Assert.isNotNull((Object)target, (String)"Parameter 'target' must not be null.");
            return target.toString();
        }
    }
}

