/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.im.AbstractIMConnection;
import hudson.plugins.im.GroupChatIMMessageTarget;
import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMConnectionListener;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessage;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMPresence;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.im.bot.Bot;
import hudson.plugins.im.tools.Assert;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.plugins.jabber.im.transport.JabberChat;
import hudson.plugins.jabber.im.transport.JabberIMConnection;
import hudson.plugins.jabber.im.transport.JabberMessage;
import hudson.plugins.jabber.im.transport.JabberMultiUserChat;
import hudson.plugins.jabber.im.transport.JabberPublisherDescriptor;
import hudson.plugins.jabber.im.transport.JabberUtil;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SSLXMPPConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.ToContainsFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;

class JabberIMConnection
extends AbstractIMConnection {
    private static final Logger LOGGER = Logger.getLogger(JabberIMConnection.class.getName());
    private volatile XMPPConnection connection;
    private final Map<String, WeakReference<GroupChat>> groupChatCache = new HashMap();
    private final Map<String, WeakReference<Chat>> chatCache = new HashMap();
    private final Set<Bot> bots = new HashSet();
    private final String passwd;
    private final String botCommandPrefix;
    private final String nick;
    private final String groupChatNick;
    private final String hostname;
    private final int port;
    private final boolean legacySSL;
    private final String[] groupChats;
    private IMPresence impresence;
    private String imStatusMessage;
    private final JabberPublisherDescriptor desc;
    private final Authentication authentication;
    private final Map<IMConnectionListener, ConnectionListener> listeners = new ConcurrentHashMap();

    JabberIMConnection(JabberPublisherDescriptor desc, Authentication authentication) throws IMException {
        super((IMPublisherDescriptor)desc);
        Assert.isNotNull((Object)desc, (String)"Parameter 'desc' must not be null.");
        this.desc = desc;
        this.authentication = authentication;
        this.hostname = desc.getHost();
        this.port = desc.getPort();
        this.legacySSL = desc.isLegacySSL();
        this.nick = JabberUtil.getUserPart((String)desc.getJabberId());
        this.passwd = desc.getPassword();
        this.groupChatNick = desc.getGroupChatNickname() != null ? desc.getGroupChatNickname() : this.nick;
        this.botCommandPrefix = desc.getCommandPrefix();
        this.groupChats = desc.getInitialGroupChats() != null ? desc.getInitialGroupChats().trim().split("\\s") : new String[0];
        this.impresence = desc.isExposePresence() ? IMPresence.AVAILABLE : IMPresence.UNAVAILABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect() {
        this.lock();
        try {
            if (!this.isConnected()) {
                if (this.createConnection()) {
                    LOGGER.info("Connected to XMPP on " + this.desc.getHost() + ":" + this.port);
                    this.sendPresence();
                    this.groupChatCache.clear();
                    for (String groupChatName : this.groupChats) {
                        try {
                            groupChatName = groupChatName.trim();
                            this.getGroupChat(groupChatName);
                            LOGGER.info("Joined groupchat " + groupChatName);
                        }
                        catch (IMException e) {
                            LOGGER.warning("Unable to connect to groupchat '" + groupChatName + "'. Did you append @conference or so to the name?\n" + "Exception: " + ExceptionHelper.dump((Throwable)e));
                        }
                    }
                } else {
                    if (this.connection != null) {
                        try {
                            this.connection.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    boolean e = false;
                    return e;
                }
            }
            boolean e = true;
            return e;
        }
        catch (Exception e) {
            LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock();
        try {
            try {
                for (WeakReference entry : this.groupChatCache.values()) {
                    GroupChat chat = (GroupChat)entry.get();
                    if (chat == null || !chat.isJoined()) continue;
                    chat.leave();
                }
                this.groupChatCache.clear();
                this.chatCache.clear();
                if (this.connection.isConnected()) {
                    this.connection.close();
                }
            }
            catch (Exception e) {
                LOGGER.fine(e.toString());
            }
            finally {
                this.connection = null;
            }
        }
        finally {
            this.unlock();
        }
    }

    private boolean createConnection() throws XMPPException {
        String serviceName;
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if ((serviceName = this.desc.getServiceName()) == null) {
            this.connection = this.legacySSL ? new SSLXMPPConnection(this.desc.getHostname(), this.port) : new XMPPConnection(this.desc.getHostname(), this.port);
        } else if (this.desc.getHostname() == null) {
            this.connection = this.legacySSL ? new SSLXMPPConnection(serviceName) : new XMPPConnection(serviceName);
        } else {
            Object object = this.connection = this.legacySSL ? new SSLXMPPConnection(this.desc.getHostname(), this.port, serviceName) : new XMPPConnection(this.hostname, this.port, serviceName);
        }
        if (this.connection.isConnected()) {
            this.connection.login(this.desc.getUserName(), this.passwd, "Hudson");
            AndFilter filter = new AndFilter((PacketFilter)new MessageTypeFilter(Message.Type.CHAT), (PacketFilter)new ToContainsFilter(this.desc.getUserName()));
            IMListener listener = new IMListener(this, null);
            this.connection.addPacketListener((PacketListener)listener, (PacketFilter)filter);
        }
        return this.connection.isAuthenticated();
    }

    private GroupChat getGroupChat(String groupChatName) throws IMException {
        boolean create;
        WeakReference ref = (WeakReference)this.groupChatCache.get(groupChatName);
        GroupChat groupChat = null;
        if (ref != null) {
            groupChat = (GroupChat)ref.get();
        }
        boolean bl = create = groupChat == null;
        if (create) {
            groupChat = this.connection.createGroupChat(groupChatName);
            try {
                groupChat.join(this.groupChatNick);
            }
            catch (XMPPException e) {
                LOGGER.warning("Cannot join group chat '" + groupChatName + "'. Exception:\n" + ExceptionHelper.dump((Throwable)e));
                throw new IMException((Exception)((Object)e));
            }
            while (groupChat.pollMessage() != null) {
            }
            this.bots.add(new Bot((IMChat)new JabberMultiUserChat(groupChat), this.groupChatNick, this.desc.getHost(), this.botCommandPrefix, this.authentication));
            this.groupChatCache.put(groupChatName, new WeakReference<GroupChat>(groupChat));
        }
        return groupChat;
    }

    private Chat getChat(String chatPartner, Message msg) {
        Chat c;
        WeakReference wr = (WeakReference)this.chatCache.get(chatPartner);
        if (wr != null && (c = (Chat)wr.get()) != null) {
            return c;
        }
        Chat chat = this.connection.createChat(chatPartner);
        Bot bot = new Bot((IMChat)new JabberChat(chat), this.groupChatNick, this.desc.getHost(), this.botCommandPrefix, this.authentication);
        this.bots.add(bot);
        if (msg != null) {
            bot.onMessage((IMMessage)new JabberMessage(msg));
        }
        this.chatCache.put(chatPartner, new WeakReference<Chat>(chat));
        return chat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(IMMessageTarget target, String text) throws IMException {
        Assert.isNotNull((Object)target, (String)"Parameter 'target' must not be null.");
        Assert.isNotNull((Object)text, (String)"Parameter 'text' must not be null.");
        try {
            if (!this.tryLock(5L, TimeUnit.SECONDS)) {
                return;
            }
            try {
                if (target instanceof GroupChatIMMessageTarget) {
                    this.getGroupChat(target.toString()).sendMessage(text);
                } else {
                    Chat chat = this.getChat(target.toString(), null);
                    chat.sendMessage(text);
                }
            }
            catch (XMPPException e) {
                LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            }
            finally {
                this.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void setPresence(IMPresence impresence, String statusMessage) throws IMException {
        Assert.isNotNull((Object)impresence, (String)"Parameter 'impresence' must not be null.");
        if (this.desc.isExposePresence()) {
            this.impresence = impresence;
            this.imStatusMessage = statusMessage;
        } else {
            this.impresence = IMPresence.UNAVAILABLE;
            this.imStatusMessage = "";
        }
        this.sendPresence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPresence() {
        try {
            if (!this.tryLock(5L, TimeUnit.SECONDS)) {
                return;
            }
            try {
                Presence presence;
                if (!this.isConnected()) {
                    return;
                }
                switch (2.$SwitchMap$hudson$plugins$im$IMPresence[this.impresence.ordinal()]) {
                    case 1: {
                        presence = new Presence(Presence.Type.AVAILABLE, this.imStatusMessage, 1, Presence.Mode.AVAILABLE);
                        break;
                    }
                    case 2: {
                        presence = new Presence(Presence.Type.AVAILABLE, this.imStatusMessage, 1, Presence.Mode.AWAY);
                        break;
                    }
                    case 3: {
                        presence = new Presence(Presence.Type.AVAILABLE, this.imStatusMessage, 1, Presence.Mode.DO_NOT_DISTURB);
                        break;
                    }
                    case 4: {
                        presence = new Presence(Presence.Type.UNAVAILABLE);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Don't know how to handle " + this.impresence);
                    }
                }
                this.connection.sendPacket((Packet)presence);
            }
            finally {
                this.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        this.lock();
        try {
            boolean bl = this.connection != null && this.connection.isAuthenticated();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(IMConnectionListener listener) {
        this.lock();
        try {
            1 l = new /* Unavailable Anonymous Inner Class!! */;
            this.listeners.put(listener, l);
            this.connection.addConnectionListener((ConnectionListener)l);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(IMConnectionListener listener) {
        this.lock();
        try {
            ConnectionListener l = (ConnectionListener)this.listeners.remove(listener);
            if (l != null) {
                this.connection.removeConnectionListener(l);
            } else {
                LOGGER.warning("Connection listener " + listener + " not found.");
            }
        }
        finally {
            this.unlock();
        }
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static /* synthetic */ Chat access$200(JabberIMConnection x0, String x1, Message x2) {
        return x0.getChat(x1, x2);
    }
}

