/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMMessageTargetConversionException;
import hudson.plugins.im.IMMessageTargetConverter;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.im.NotificationStrategy;
import hudson.plugins.im.tools.Assert;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.plugins.jabber.im.transport.JabberIMConnectionProvider;
import hudson.plugins.jabber.im.transport.JabberPublisher;
import hudson.plugins.jabber.im.transport.JabberUtil;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class JabberPublisherDescriptor
extends BuildStepDescriptor<Publisher>
implements IMPublisherDescriptor {
    private static final Logger LOGGER = Logger.getLogger(JabberPublisherDescriptor.class.getName());
    private static final String PREFIX = "jabberPlugin.";
    public static final String PARAMETERNAME_ENABLED = "jabberPlugin.enabled";
    public static final String PARAMETERNAME_PORT = "jabberPlugin.port";
    public static final String PARAMETERNAME_HOSTNAME = "jabberPlugin.hostname";
    public static final String PARAMETERNAME_SSL = "jabberPlugin.ssl";
    public static final String PARAMETERNAME_PRESENCE = "jabberPlugin.exposePresence";
    public static final String PARAMETERNAME_PASSWORD = "jabberPlugin.password";
    public static final String PARAMETERNAME_JABBERID = "jabberPlugin.jabberId";
    public static final String PARAMETERNAME_GROUP_NICKNAME = "jabberPlugin.groupNick";
    public static final String PARAMETERNAME_TARGETS = "jabberPlugin.targets";
    public static final String PARAMETERNAME_STRATEGY = "jabberPlugin.strategy";
    public static final String PARAMETERNAME_NOTIFY_START = "jabberPlugin.notifyStart";
    public static final String PARAMETERNAME_NOTIFY_SUSPECTS = "jabberPlugin.notifySuspects";
    public static final String PARAMETERNAME_NOTIFY_CULPRITS = "jabberPlugin.notifyCulprits";
    public static final String PARAMETERNAME_NOTIFY_FIXERS = "jabberPlugin.notifyFixers";
    public static final String PARAMETERNAME_NOTIFY_UPSTREAM_COMMITTERS = "jabberPlugin.notifyUpstreamCommitters";
    public static final String PARAMETERNAME_INITIAL_GROUPCHATS = "jabberPlugin.initialGroupChats";
    public static final String PARAMETERNAME_COMMAND_PREFIX = "jabberPlugin.commandPrefix";
    public static final String PARAMETERNAME_DEFAULT_ID_SUFFIX = "jabberPlugin.defaultIdSuffix";
    public static final String PARAMETERNAME_HUDSON_LOGIN = "jabberPlugin.hudsonLogin";
    public static final String PARAMETERNAME_HUDSON_PASSWORD = "jabberPlugin.hudsonPassword";
    public static final String[] PARAMETERVALUE_STRATEGY_VALUES = NotificationStrategy.getDisplayNames();
    public static final String PARAMETERVALUE_STRATEGY_DEFAULT = NotificationStrategy.STATECHANGE_ONLY.getDisplayName();
    public static final String DEFAULT_COMMAND_PREFIX = "!";
    private static final int DEFAULT_PORT = 5222;
    private Boolean enabled;
    private int port = 5222;
    private String hostname = null;
    private boolean legacySSL = false;
    private String hudsonNickname = "hudson";
    private String hudsonPassword = "secret";
    private String groupChatNickname = null;
    private boolean exposePresence = true;
    private String initialGroupChats = null;
    private String commandPrefix = "!";
    private String defaultIdSuffix;
    private String hudsonCiLogin;
    private String hudsonCiPassword;

    public JabberPublisherDescriptor() {
        super(JabberPublisher.class);
        this.load();
        if (this.isEnabled()) {
            try {
                JabberIMConnectionProvider.setDesc((IMPublisherDescriptor)this);
            }
            catch (Exception e) {
                LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            }
        } else {
            try {
                JabberIMConnectionProvider.setDesc(null);
            }
            catch (IMException iMException) {
                // empty catch block
            }
        }
    }

    public void load() {
        super.load();
        if (this.enabled == null) {
            this.enabled = Util.fixEmptyAndTrim((String)this.hudsonNickname) != null ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private void applyHostname(HttpServletRequest req) throws Descriptor.FormException {
        String s = req.getParameter("jabberPlugin.hostname");
        if (s != null && s.trim().length() > 0) {
            try {
                InetAddress.getByName(s);
                this.hostname = s;
            }
            catch (UnknownHostException e) {
                throw new Descriptor.FormException("Cannot find Host '" + s + "'.", "jabberPlugin.hostname");
            }
        } else {
            this.hostname = null;
        }
    }

    private void applyNickname(HttpServletRequest req) throws Descriptor.FormException {
        this.hudsonNickname = req.getParameter("jabberPlugin.jabberId");
        if (this.hostname != null && (this.hudsonNickname == null || this.hudsonNickname.trim().length() == 0)) {
            throw new Descriptor.FormException("Account/Nickname cannot be empty.", "jabberPlugin.jabberId");
        }
    }

    private void applyPassword(HttpServletRequest req) throws Descriptor.FormException {
        this.hudsonPassword = req.getParameter("jabberPlugin.password");
        if (this.hostname != null && this.hudsonPassword == null || this.hudsonPassword.trim().length() == 0) {
            throw new Descriptor.FormException("Password cannot be empty.", "jabberPlugin.password");
        }
    }

    private void applyGroupChatNickname(HttpServletRequest req) throws Descriptor.FormException {
        this.groupChatNickname = req.getParameter("jabberPlugin.groupNick");
        if (this.groupChatNickname != null && this.groupChatNickname.trim().length() == 0) {
            this.groupChatNickname = null;
        }
    }

    private void applyPort(HttpServletRequest req) throws Descriptor.FormException {
        String p = Util.fixEmptyAndTrim((String)req.getParameter("jabberPlugin.port"));
        if (p != null) {
            try {
                int i = Integer.parseInt(p);
                if (i < 0 || i > 65535) {
                    throw new Descriptor.FormException("Port out of range.", "jabberPlugin.port");
                }
                this.port = i;
            }
            catch (NumberFormatException e) {
                throw new Descriptor.FormException("Port cannot be parsed.", "jabberPlugin.port");
            }
        } else {
            this.port = 5222;
        }
    }

    private void applyLegacySSL(HttpServletRequest req) {
        this.legacySSL = req.getParameter("jabberPlugin.ssl") != null;
    }

    private void applyPresence(HttpServletRequest req) {
        this.exposePresence = req.getParameter("jabberPlugin.exposePresence") != null;
    }

    private void applyInitialGroupChats(HttpServletRequest req) {
        this.initialGroupChats = Util.fixEmptyAndTrim((String)req.getParameter("jabberPlugin.initialGroupChats"));
    }

    private void applyCommandPrefix(HttpServletRequest req) {
        String prefix = req.getParameter("jabberPlugin.commandPrefix");
        this.commandPrefix = prefix != null && prefix.trim().length() > 0 ? prefix : "!";
    }

    private void applyDefaultIdSuffix(HttpServletRequest req) {
        String suffix = req.getParameter("jabberPlugin.defaultIdSuffix");
        this.defaultIdSuffix = suffix != null && suffix.trim().length() > 0 ? suffix.trim() : "";
    }

    private void applyHudsonLoginPassword(HttpServletRequest req) throws Descriptor.FormException {
        this.hudsonCiLogin = Util.fixEmptyAndTrim((String)req.getParameter("jabberPlugin.hudsonLogin"));
        this.hudsonCiPassword = Util.fixEmptyAndTrim((String)req.getParameter("jabberPlugin.hudsonPassword"));
        if (this.hudsonCiLogin != null) {
            UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)this.hudsonCiLogin, (Object)this.hudsonCiPassword);
            try {
                Hudson.getInstance().getSecurityRealm().getSecurityComponents().manager.authenticate((Authentication)auth);
            }
            catch (AuthenticationException e) {
                throw new Descriptor.FormException((Throwable)e, "Bad Hudson credentials");
            }
        }
    }

    public String getDisplayName() {
        return "Jabber Notification";
    }

    public String getPluginDescription() {
        return "Jabber plugin";
    }

    public boolean isEnabled() {
        return Boolean.TRUE.equals(this.enabled);
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getHost() {
        if (StringUtils.isNotBlank((String)this.hostname)) {
            return this.hostname;
        }
        return this.getServiceName();
    }

    public String getJabberId() {
        return this.hudsonNickname;
    }

    public String getPassword() {
        return this.hudsonPassword;
    }

    public String getGroupChatNickname() {
        return this.groupChatNickname;
    }

    public int getPort() {
        return this.port;
    }

    public String getPortString() {
        if (this.port == 5222) {
            return null;
        }
        return String.valueOf(this.port);
    }

    public boolean isLegacySSL() {
        return this.legacySSL;
    }

    public boolean isExposePresence() {
        return this.exposePresence;
    }

    public String getInitialGroupChats() {
        return Util.fixEmptyAndTrim((String)this.initialGroupChats);
    }

    public String getDefaultIdSuffix() {
        return this.defaultIdSuffix;
    }

    public String getCommandPrefix() {
        return this.commandPrefix;
    }

    public JabberPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        Assert.isNotNull((Object)req, (String)"Parameter 'req' must not be null.");
        String t = req.getParameter("jabberPlugin.targets");
        String[] split = t != null ? t.split("\\s") : new String[]{};
        ArrayList<IMMessageTarget> targets = new ArrayList<IMMessageTarget>(split.length);
        try {
            IMMessageTargetConverter conv = this.getIMMessageTargetConverter();
            for (String fragment : split) {
                IMMessageTarget createIMMessageTarget = conv.fromString(fragment);
                if (createIMMessageTarget == null) continue;
                targets.add(createIMMessageTarget);
            }
        }
        catch (IMMessageTargetConversionException e) {
            throw new Descriptor.FormException("Invalid Jabber address", (Throwable)e, "jabberPlugin.targets");
        }
        String n = req.getParameter("jabberPlugin.strategy");
        if (n == null) {
            n = PARAMETERVALUE_STRATEGY_DEFAULT;
        } else {
            boolean foundStrategyValueMatch = false;
            for (String strategyValue : PARAMETERVALUE_STRATEGY_VALUES) {
                if (!strategyValue.equals(n)) continue;
                foundStrategyValueMatch = true;
                break;
            }
            if (!foundStrategyValueMatch) {
                n = PARAMETERVALUE_STRATEGY_DEFAULT;
            }
        }
        boolean notifyStart = "on".equals(req.getParameter("jabberPlugin.notifyStart"));
        boolean notifySuspects = "on".equals(req.getParameter("jabberPlugin.notifySuspects"));
        boolean notifyCulprits = "on".equals(req.getParameter("jabberPlugin.notifyCulprits"));
        boolean notifyFixers = "on".equals(req.getParameter("jabberPlugin.notifyFixers"));
        boolean notifyUpstream = "on".equals(req.getParameter("jabberPlugin.notifyUpstreamCommitters"));
        try {
            return new JabberPublisher(targets, n, notifyStart, notifySuspects, notifyCulprits, notifyFixers, notifyUpstream);
        }
        catch (IMMessageTargetConversionException e) {
            throw new Descriptor.FormException((Throwable)e, "jabberPlugin.targets");
        }
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        String en = req.getParameter("jabberPlugin.enabled");
        this.enabled = en != null;
        this.applyPresence((HttpServletRequest)req);
        this.applyHostname((HttpServletRequest)req);
        this.applyPort((HttpServletRequest)req);
        this.applyLegacySSL((HttpServletRequest)req);
        this.applyNickname((HttpServletRequest)req);
        this.applyPassword((HttpServletRequest)req);
        this.applyGroupChatNickname((HttpServletRequest)req);
        this.applyInitialGroupChats((HttpServletRequest)req);
        this.applyCommandPrefix((HttpServletRequest)req);
        this.applyDefaultIdSuffix((HttpServletRequest)req);
        this.applyHudsonLoginPassword((HttpServletRequest)req);
        if (this.isEnabled()) {
            try {
                JabberIMConnectionProvider.setDesc((IMPublisherDescriptor)this);
                JabberIMConnectionProvider.getInstance().currentConnection();
            }
            catch (Exception e) {
                LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            }
        } else {
            JabberIMConnectionProvider.getInstance().releaseConnection();
            try {
                JabberIMConnectionProvider.setDesc(null);
            }
            catch (IMException e) {
                // empty catch block
            }
            LOGGER.info("No hostname specified.");
        }
        this.save();
        return super.configure(req, json);
    }

    public FormValidation doJabberIdCheck(@QueryParameter String jabberId, @QueryParameter String hostname, @QueryParameter String port) {
        if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
            return FormValidation.ok();
        }
        if (jabberId == null || jabberId.trim().length() == 0) {
            return FormValidation.error((String)"Jabber ID must not be empty!");
        }
        if (Util.fixEmptyAndTrim((String)hostname) != null) {
            return FormValidation.ok();
        }
        if (JabberUtil.getDomainPart((String)jabberId) != null) {
            String host = JabberUtil.getDomainPart((String)jabberId);
            try {
                JabberPublisherDescriptor.checkHostAccessibility((String)host, (String)port);
                return FormValidation.ok();
            }
            catch (UnknownHostException e) {
                return FormValidation.error((String)("Unknown host " + host));
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)("Invalid port " + port));
            }
            catch (IOException e) {
                return FormValidation.error((String)("Unable to connect to " + hostname + ":" + port + " : " + e.getMessage()));
            }
        }
        return FormValidation.error((String)"No hostname specified - neither via 'Jabber ID' nor via 'Server'!");
    }

    public FormValidation doServerCheck(@QueryParameter String hostname, @QueryParameter String port, @QueryParameter boolean legacySSL) {
        if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
            return FormValidation.ok();
        }
        String host = Util.fixEmptyAndTrim((String)hostname);
        String p = Util.fixEmptyAndTrim((String)port);
        if (host == null) {
            return FormValidation.ok();
        }
        try {
            JabberPublisherDescriptor.checkHostAccessibility((String)host, (String)port);
            return FormValidation.ok();
        }
        catch (UnknownHostException e) {
            return FormValidation.error((String)("Unknown host " + host));
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)("Invalid port " + port));
        }
        catch (IOException e) {
            return FormValidation.error((String)("Unable to connect to " + hostname + ":" + p + " : " + e.getMessage()));
        }
    }

    private static void checkHostAccessibility(String hostname, String port) throws UnknownHostException, IOException, NumberFormatException {
        hostname = Util.fixEmptyAndTrim((String)hostname);
        port = Util.fixEmptyAndTrim((String)port);
        int iPort = 5222;
        InetAddress address = InetAddress.getByName(hostname);
        if (port != null) {
            iPort = Integer.parseInt(port);
        }
        Socket s = new Socket(address, iPort);
        s.close();
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public String getUserName() {
        return JabberUtil.getUserPart((String)this.getJabberId());
    }

    String getServiceName() {
        return JabberUtil.getDomainPart((String)this.getJabberId());
    }

    public String getHudsonPassword() {
        return this.hudsonCiPassword;
    }

    public String getHudsonUserName() {
        return this.hudsonCiLogin;
    }

    public IMMessageTargetConverter getIMMessageTargetConverter() {
        return JabberPublisher.CONVERTER;
    }

    public List<IMMessageTarget> getDefaultTargets() {
        return Collections.emptyList();
    }
}

