/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageListener;
import hudson.plugins.jabber.im.transport.JabberIMConnection;
import hudson.plugins.jabber.im.transport.JabberMUCMessageListenerAdapter;
import hudson.plugins.jabber.im.transport.JabberUtil;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.muc.MultiUserChat;

public class JabberMultiUserChat
implements IMChat {
    private final MultiUserChat chat;
    private final JabberIMConnection connection;

    public JabberMultiUserChat(MultiUserChat chat, JabberIMConnection connection) {
        this.chat = chat;
        this.connection = connection;
    }

    public void sendMessage(String msg) throws IMException {
        try {
            this.chat.sendMessage(msg);
        }
        catch (XMPPException e) {
            throw new IMException((Exception)((Object)e));
        }
    }

    public String getNickName(String sender) {
        String resource = JabberUtil.getResourcePart(sender);
        if (resource != null) {
            return resource;
        }
        return sender;
    }

    public void addMessageListener(IMMessageListener listener) {
        this.chat.addMessageListener((PacketListener)new JabberMUCMessageListenerAdapter(listener, this.connection, this.chat));
    }

    public void removeMessageListener(IMMessageListener listener) {
    }

    public boolean isMultiUserChat() {
        return true;
    }
}

