/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageListener;
import hudson.plugins.jabber.im.transport.JabberIMConnection;
import hudson.plugins.jabber.im.transport.JabberMessageListenerAdapter;
import hudson.plugins.jabber.im.transport.JabberUtil;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.XMPPException;

public class JabberChat
implements IMChat {
    private final Chat chat;
    private final JabberIMConnection connection;

    public JabberChat(Chat chat, JabberIMConnection connection) {
        this.chat = chat;
        this.connection = connection;
    }

    public void sendMessage(String msg) throws IMException {
        try {
            this.chat.sendMessage(msg);
        }
        catch (XMPPException e) {
            throw new IMException((Exception)((Object)e));
        }
    }

    public String getNickName(String sender) {
        return JabberUtil.getUserPart(sender);
    }

    public void addMessageListener(IMMessageListener listener) {
        this.chat.addMessageListener((MessageListener)new JabberMessageListenerAdapter(listener, this.connection, this.chat));
    }

    public void removeMessageListener(IMMessageListener listener) {
    }

    public boolean isMultiUserChat() {
        return false;
    }
}

