/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.im.AbstractIMConnection;
import hudson.plugins.im.GroupChatIMMessageTarget;
import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMConnectionListener;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessage;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMPresence;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.im.bot.Bot;
import hudson.plugins.im.tools.Assert;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.plugins.jabber.im.transport.JabberChat;
import hudson.plugins.jabber.im.transport.JabberMessage;
import hudson.plugins.jabber.im.transport.JabberMultiUserChat;
import hudson.plugins.jabber.im.transport.JabberPublisherDescriptor;
import hudson.plugins.jabber.im.transport.JabberUtil;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.ToContainsFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.jivesoftware.smackx.packet.MessageEvent;
import org.jivesoftware.smackx.packet.XHTMLExtension;

class JabberIMConnection
extends AbstractIMConnection {
    private static final Logger LOGGER = Logger.getLogger(JabberIMConnection.class.getName());
    private volatile XMPPConnection connection;
    private final Map<String, WeakReference<MultiUserChat>> groupChatCache = new HashMap<String, WeakReference<MultiUserChat>>();
    private final Map<String, WeakReference<Chat>> chatCache = new HashMap<String, WeakReference<Chat>>();
    private final Set<Bot> bots = new HashSet<Bot>();
    private final String passwd;
    private final String botCommandPrefix;
    private final String nick;
    private final String groupChatNick;
    private final String hostname;
    private final int port;
    private final String[] groupChats;
    private IMPresence impresence;
    private String imStatusMessage;
    private boolean enableSASL;
    private final JabberPublisherDescriptor desc;
    private final Authentication authentication;
    private Roster roster;
    private final Map<IMConnectionListener, ConnectionListener> listeners = new ConcurrentHashMap<IMConnectionListener, ConnectionListener>();

    JabberIMConnection(JabberPublisherDescriptor desc, Authentication authentication) throws IMException {
        super((IMPublisherDescriptor)desc);
        Assert.isNotNull((Object)((Object)desc), (String)"Parameter 'desc' must not be null.");
        this.desc = desc;
        this.authentication = authentication;
        this.hostname = desc.getHost();
        this.port = desc.getPort();
        this.nick = JabberUtil.getUserPart(desc.getJabberId());
        this.passwd = desc.getPassword();
        this.enableSASL = desc.isEnableSASL();
        this.groupChatNick = desc.getGroupChatNickname() != null ? desc.getGroupChatNickname() : this.nick;
        this.botCommandPrefix = desc.getCommandPrefix();
        this.groupChats = desc.getInitialGroupChats() != null ? desc.getInitialGroupChats().trim().split("\\s") : new String[0];
        this.impresence = desc.isExposePresence() ? IMPresence.AVAILABLE : IMPresence.UNAVAILABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect() {
        this.lock();
        try {
            if (!this.isConnected()) {
                if (this.createConnection()) {
                    LOGGER.info("Connected to XMPP on " + this.connection.getHost() + ":" + this.connection.getPort() + "/" + this.connection.getServiceName() + (this.connection.isUsingTLS() ? " using TLS" : "") + (this.connection.isUsingCompression() ? " using compression" : ""));
                    this.sendPresence();
                    this.groupChatCache.clear();
                    for (String groupChatName : this.groupChats) {
                        try {
                            groupChatName = groupChatName.trim();
                            this.getGroupChat(groupChatName);
                            LOGGER.info("Joined groupchat " + groupChatName);
                        }
                        catch (IMException e) {
                            LOGGER.warning("Unable to connect to groupchat '" + groupChatName + "'. Did you append @conference or so to the name?\n" + "Exception: " + ExceptionHelper.dump((Throwable)e));
                        }
                    }
                } else {
                    if (this.connection != null) {
                        try {
                            this.connection.disconnect();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    boolean e = false;
                    return e;
                }
            }
            boolean e = true;
            return e;
        }
        catch (Exception e) {
            LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock();
        try {
            try {
                for (WeakReference<MultiUserChat> entry : this.groupChatCache.values()) {
                    MultiUserChat chat = (MultiUserChat)entry.get();
                    if (chat == null || !chat.isJoined()) continue;
                    chat.leave();
                }
                this.groupChatCache.clear();
                this.chatCache.clear();
                if (this.connection.isConnected()) {
                    this.connection.disconnect();
                }
            }
            catch (Exception e) {
                LOGGER.fine(e.toString());
            }
            finally {
                this.connection = null;
            }
        }
        finally {
            this.unlock();
        }
    }

    private boolean createConnection() throws XMPPException {
        String serviceName;
        if (this.connection != null) {
            try {
                this.connection.disconnect();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        ConnectionConfiguration cfg = (serviceName = this.desc.getServiceName()) == null ? new ConnectionConfiguration(this.hostname, this.port) : (this.hostname == null ? new ConnectionConfiguration(serviceName) : new ConnectionConfiguration(this.hostname, this.port, serviceName));
        cfg.setReconnectionAllowed(false);
        SASLAuthentication.unregisterSASLMechanism((String)"DIGEST-MD5");
        cfg.setSASLAuthenticationEnabled(this.enableSASL);
        this.connection = new XMPPConnection(cfg);
        this.connection.connect();
        if (this.connection.isConnected()) {
            this.connection.login(this.desc.getUserName(), this.passwd, "Hudson");
            this.roster = this.connection.getRoster();
            Roster.SubscriptionMode mode = Roster.SubscriptionMode.valueOf((String)this.desc.getSubscriptionMode());
            switch (mode) {
                case accept_all: {
                    LOGGER.info("Accepting all subscription requests");
                    break;
                }
                case reject_all: {
                    LOGGER.info("Rejecting all subscription requests");
                    break;
                }
                case manual: {
                    LOGGER.info("Subscription requests must be handled manually");
                }
            }
            this.roster.setSubscriptionMode(mode);
            AndFilter filter = new AndFilter(new PacketFilter[]{new MessageTypeFilter(Message.Type.chat), new ToContainsFilter(this.desc.getUserName())});
            IMListener listener = new IMListener();
            this.connection.addPacketListener((PacketListener)listener, (PacketFilter)filter);
        }
        return this.connection.isAuthenticated();
    }

    private MultiUserChat getGroupChat(String groupChatName) throws IMException {
        boolean create;
        WeakReference<MultiUserChat> ref = this.groupChatCache.get(groupChatName);
        MultiUserChat groupChat = null;
        if (ref != null) {
            groupChat = (MultiUserChat)ref.get();
        }
        boolean bl = create = groupChat == null;
        if (create) {
            groupChat = new MultiUserChat(this.connection, groupChatName);
            try {
                groupChat.join(this.groupChatNick);
            }
            catch (XMPPException e) {
                LOGGER.warning("Cannot join group chat '" + groupChatName + "'. Exception:\n" + ExceptionHelper.dump((Throwable)e));
                throw new IMException((Exception)((Object)e));
            }
            while (groupChat.pollMessage() != null) {
            }
            this.bots.add(new Bot((IMChat)new JabberMultiUserChat(groupChat, this), this.groupChatNick, this.desc.getHost(), this.botCommandPrefix, this.authentication));
            this.groupChatCache.put(groupChatName, new WeakReference<MultiUserChat>(groupChat));
        }
        return groupChat;
    }

    private Chat getChat(String chatPartner, Message msg) {
        Chat c;
        WeakReference<Chat> wr = this.chatCache.get(chatPartner);
        if (wr != null && (c = (Chat)wr.get()) != null) {
            return c;
        }
        Chat chat = this.connection.getChatManager().createChat(chatPartner, null);
        Bot bot = new Bot((IMChat)new JabberChat(chat, this), this.groupChatNick, this.desc.getHost(), this.botCommandPrefix, this.authentication);
        this.bots.add(bot);
        if (msg != null) {
            bot.onMessage((IMMessage)new JabberMessage(msg, this.isAuthorized(msg.getFrom())));
        }
        this.chatCache.put(chatPartner, new WeakReference<Chat>(chat));
        return chat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(IMMessageTarget target, String text) throws IMException {
        Assert.isNotNull((Object)target, (String)"Parameter 'target' must not be null.");
        Assert.isNotNull((Object)text, (String)"Parameter 'text' must not be null.");
        try {
            if (!this.tryLock(5L, TimeUnit.SECONDS)) {
                return;
            }
            try {
                if (target instanceof GroupChatIMMessageTarget) {
                    this.getGroupChat(target.toString()).sendMessage(text);
                } else {
                    Chat chat = this.getChat(target.toString(), null);
                    chat.sendMessage(text);
                }
            }
            catch (XMPPException e) {
                LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            }
            finally {
                this.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void setPresence(IMPresence impresence, String statusMessage) throws IMException {
        Assert.isNotNull((Object)impresence, (String)"Parameter 'impresence' must not be null.");
        if (this.desc.isExposePresence()) {
            this.impresence = impresence;
            this.imStatusMessage = statusMessage;
            this.sendPresence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPresence() {
        try {
            if (!this.tryLock(5L, TimeUnit.SECONDS)) {
                return;
            }
            try {
                Presence presence;
                if (!this.isConnected()) {
                    return;
                }
                switch (this.impresence) {
                    case AVAILABLE: {
                        presence = new Presence(Presence.Type.available, this.imStatusMessage, 1, Presence.Mode.available);
                        break;
                    }
                    case OCCUPIED: {
                        presence = new Presence(Presence.Type.available, this.imStatusMessage, 1, Presence.Mode.away);
                        break;
                    }
                    case DND: {
                        presence = new Presence(Presence.Type.available, this.imStatusMessage, 1, Presence.Mode.dnd);
                        break;
                    }
                    case UNAVAILABLE: {
                        presence = new Presence(Presence.Type.unavailable);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Don't know how to handle " + this.impresence);
                    }
                }
                this.connection.sendPacket((Packet)presence);
            }
            finally {
                this.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        this.lock();
        try {
            boolean bl = this.connection != null && this.connection.isAuthenticated();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public boolean isAuthorized(String xmppAddress) {
        String bareAddress = StringUtils.parseBareAddress((String)xmppAddress);
        RosterEntry entry = this.roster.getEntry(bareAddress);
        boolean authorized = entry != null && (entry.getType() == RosterPacket.ItemType.both || entry.getType() == RosterPacket.ItemType.from);
        return authorized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(final IMConnectionListener listener) {
        this.lock();
        try {
            ConnectionListener l = new ConnectionListener(){

                public void connectionClosedOnError(Exception e) {
                    listener.connectionBroken(e);
                }

                public void connectionClosed() {
                }

                public void reconnectingIn(int paramInt) {
                }

                public void reconnectionFailed(Exception paramException) {
                }

                public void reconnectionSuccessful() {
                }
            };
            this.listeners.put(listener, l);
            this.connection.addConnectionListener(l);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(IMConnectionListener listener) {
        this.lock();
        try {
            ConnectionListener l = this.listeners.remove(listener);
            if (l != null) {
                this.connection.removeConnectionListener(l);
            } else {
                LOGGER.warning("Connection listener " + listener + " not found.");
            }
        }
        finally {
            this.unlock();
        }
    }

    private final class IMListener
    implements PacketListener {
        private IMListener() {
        }

        public void processPacket(Packet packet) {
            if (packet instanceof Message) {
                Message m = (Message)packet;
                boolean composing = false;
                boolean xhtmlMessage = false;
                for (PacketExtension ext : m.getExtensions()) {
                    MessageEvent me;
                    if (ext instanceof DelayInformation) {
                        return;
                    }
                    if (ext instanceof MessageEvent && (me = (MessageEvent)ext).isComposing()) {
                        composing = true;
                    }
                    if (!(ext instanceof XHTMLExtension)) continue;
                    xhtmlMessage = true;
                }
                if (composing && !xhtmlMessage) {
                    return;
                }
                if (m.getBody() != null) {
                    LOGGER.info("Message from " + m.getFrom() + " : " + m.getBody());
                    String chatPartner = m.getFrom();
                    JabberIMConnection.this.getChat(chatPartner, m);
                }
            }
        }
    }
}

