/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.Util;

public class JabberUtil {
    private JabberUtil() {
    }

    public static String getUserPart(String jabberId) {
        int idx = jabberId.indexOf(64);
        if (idx == -1) {
            return jabberId;
        }
        String userPart = jabberId.substring(0, idx);
        if (Util.fixEmptyAndTrim((String)userPart) == null) {
            throw new IllegalArgumentException("Missing user part in " + jabberId);
        }
        return userPart;
    }

    public static String getDomainPart(String jabberId) {
        int atIdx = jabberId.indexOf(64);
        if (atIdx == -1) {
            return null;
        }
        int slashIdx = jabberId.indexOf(47, atIdx);
        if (slashIdx == -1) {
            if (atIdx + 1 < jabberId.length()) {
                return jabberId.substring(atIdx + 1);
            }
            return null;
        }
        return jabberId.substring(atIdx + 1, slashIdx);
    }

    public static String getResourcePart(String jabberId) {
        int atIdx = jabberId.indexOf(64);
        if (atIdx == -1) {
            return null;
        }
        int slashIdx = jabberId.indexOf(47, atIdx);
        if (slashIdx == -1) {
            return null;
        }
        if (slashIdx + 1 < jabberId.length()) {
            return jabberId.substring(slashIdx + 1);
        }
        return null;
    }
}

