/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.japex;

import com.sun.japex.RegressionDetector;
import com.sun.japex.report.TestSuiteReport;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.japex.JapexPublisher;
import hudson.plugins.japex.JapexReportAction;
import hudson.plugins.japex.JapexReportBuildAction;
import hudson.tasks.Mailer;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class JapexPublisher
extends Publisher {
    private String includes;
    private boolean trackRegressions;
    private double regressionThreshold;
    private String regressionAddress;
    public static final Descriptor<Publisher> DESCRIPTOR = new DescriptorImpl();

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public boolean isTrackRegressions() {
        return this.trackRegressions;
    }

    public void setTrackRegressions(boolean trackRegressions) {
        this.trackRegressions = trackRegressions;
    }

    public double getRegressionThreshold() {
        return this.regressionThreshold;
    }

    public void setRegressionThreshold(double regressionThreshold) {
        this.regressionThreshold = regressionThreshold;
    }

    public String getRegressionAddress() {
        return this.regressionAddress;
    }

    public void setRegressionAddress(String regressionAddress) {
        this.regressionAddress = Util.fixEmpty((String)Util.fixNull((String)regressionAddress).trim());
    }

    public boolean perform(Build build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("Recording japex reports " + this.includes);
        org.apache.tools.ant.Project antProject = new org.apache.tools.ant.Project();
        File outDir = JapexPublisher.getJapexReport((Build)build);
        outDir.mkdir();
        int numFiles = ((Project)build.getProject()).getWorkspace().copyRecursiveTo(this.includes, new FilePath(outDir));
        if (numFiles == 0) {
            listener.error("No matching file found. Configuration error?");
            build.setResult(Result.FAILURE);
            return true;
        }
        FileSet fs = new FileSet();
        fs.setDir(outDir);
        DirectoryScanner ds = fs.getDirectoryScanner(antProject);
        String[] includedFiles = ds.getIncludedFiles();
        File prevDir = this.getPreviousJapexReport(build);
        boolean hasRegressionReport = false;
        for (String f : includedFiles) {
            String configName;
            File file = new File(ds.getBasedir(), f);
            if (file.lastModified() < build.getTimestamp().getTimeInMillis()) {
                listener.getLogger().println("Ignoring old file: " + file);
                continue;
            }
            listener.getLogger().println(file);
            try {
                TestSuiteReport rpt = new TestSuiteReport(file);
                configName = ((String)rpt.getParameters().get("configFile")).replace('/', '.');
            }
            catch (Exception e) {
                e.printStackTrace(listener.error(e.getMessage()));
                continue;
            }
            Util.copyFile((File)file, (File)new File(outDir, configName));
            File previousConfig = new File(prevDir, configName);
            if (!previousConfig.exists()) continue;
            try {
                File regressionFile = new File(outDir, configName + ".regression");
                RegressionDetector regd = new RegressionDetector();
                regd.setOldReport(previousConfig);
                regd.setNewReport(file);
                regd.setThreshold(this.regressionThreshold);
                regd.generateXmlReport(regressionFile);
                hasRegressionReport = true;
                if (!this.trackRegressions || !regd.checkThreshold((Source)new StreamSource(regressionFile))) continue;
                listener.getLogger().println("Regression detected to " + configName);
                listener.getLogger().println("Notifying " + this.regressionAddress);
                build.setResult(Result.UNSTABLE);
                StringWriter html = new StringWriter();
                regd.generateHtmlReport((Source)new StreamSource(regressionFile), (javax.xml.transform.Result)new StreamResult(html));
                this.sendNotification(build, listener, html.toString());
            }
            catch (IOException e) {
                e.printStackTrace(listener.error("Failed to compute japex regression report for " + configName));
            }
        }
        if (hasRegressionReport) {
            build.getActions().add(new JapexReportBuildAction(build));
        }
        return true;
    }

    private void sendNotification(Build build, BuildListener listener, String payload) {
        try {
            MimeMessage msg = new MimeMessage(Mailer.DESCRIPTOR.createSession());
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.getRegressionAddress(), (boolean)false));
            msg.setFrom((Address)new InternetAddress(Mailer.DESCRIPTOR.getAdminAddress()));
            msg.setSubject("Japex performance regression in " + ((Project)build.getProject()).getName() + ' ' + build.getDisplayName());
            msg.setText(payload);
            msg.setHeader("Content-Type", "text/html");
            Transport.send((Message)msg);
        }
        catch (MessagingException e) {
            e.printStackTrace(listener.error("Failed to send out Japex notification e-mail"));
        }
    }

    private File getPreviousJapexReport(Build build) {
        if ((build = (Build)build.getPreviousNotFailedBuild()) == null) {
            return null;
        }
        return JapexPublisher.getJapexReport((Build)build);
    }

    static File getJapexReport(Build build) {
        return new File(build.getRootDir(), "japex");
    }

    public Action getProjectAction(Project project) {
        return new JapexReportAction(project);
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }
}

