/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.japex;

import com.sun.japex.report.MeanMode;
import hudson.model.ModelObject;
import hudson.model.Project;
import hudson.plugins.japex.HudsonChartGenerator;
import hudson.plugins.japex.TestCaseGraph;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrendReport
implements ModelObject {
    final HudsonChartGenerator chartGen;
    private final String configName;
    private final Project project;
    private final Map<String, String> testCaseNames = new HashMap();

    TrendReport(Project project, String configName, HudsonChartGenerator chartGen) {
        this.project = project;
        this.configName = configName;
        this.chartGen = chartGen;
        for (String name : chartGen.getTestNames()) {
            this.testCaseNames.put(name.replace('/', '_'), name);
        }
    }

    public String getDisplayName() {
        return this.configName;
    }

    public Map<String, String> getTestCaseNames() throws IOException {
        return this.testCaseNames;
    }

    public Project getProject() {
        return this.project;
    }

    public TestCaseGraph getTestCaseGraph(String safeName) {
        return new TestCaseGraph(this, (String)this.testCaseNames.get(safeName));
    }

    public void doArithmeticMeanGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.doMeanGraph(req, rsp, MeanMode.ARITHMETIC);
    }

    public void doGeometricMeanGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.doMeanGraph(req, rsp, MeanMode.GEOMETRIC);
    }

    public void doHarmonicMeanGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.doMeanGraph(req, rsp, MeanMode.HARMONIC);
    }

    private void doMeanGraph(StaplerRequest req, StaplerResponse rsp, MeanMode mean) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        if (this.chartGen.timestamp != null && req.checkIfModified(this.chartGen.timestamp, rsp)) {
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)this.chartGen.createTrendChart(mean), (int)400, (int)200);
    }
}

