/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.japex;

import com.sun.japex.RegressionDetector;
import com.sun.japex.report.TestSuiteReport;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.plugins.japex.JapexReportAction;
import hudson.plugins.japex.JapexReportBuildAction;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Mailer;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.json.JSONObject;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapexPublisher
extends Recorder {
    private String includes;
    private boolean trackRegressions;
    private double regressionThreshold;
    private String regressionAddress;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public boolean isTrackRegressions() {
        return this.trackRegressions;
    }

    public void setTrackRegressions(boolean trackRegressions) {
        this.trackRegressions = trackRegressions;
    }

    public double getRegressionThreshold() {
        return this.regressionThreshold;
    }

    public void setRegressionThreshold(double regressionThreshold) {
        this.regressionThreshold = regressionThreshold;
    }

    public String getRegressionAddress() {
        return this.regressionAddress;
    }

    public void setRegressionAddress(String regressionAddress) {
        this.regressionAddress = Util.fixEmpty((String)Util.fixNull((String)regressionAddress).trim());
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (!(build instanceof Build)) {
            return true;
        }
        listener.getLogger().println("Recording japex reports " + this.includes);
        org.apache.tools.ant.Project antProject = new org.apache.tools.ant.Project();
        File outDir = JapexPublisher.getJapexReport(build);
        outDir.mkdir();
        int numFiles = build.getWorkspace().copyRecursiveTo(this.includes, new FilePath(outDir));
        if (numFiles == 0) {
            listener.error("No matching file found. Configuration error?");
            build.setResult(hudson.model.Result.FAILURE);
            return true;
        }
        FileSet fs = new FileSet();
        fs.setDir(outDir);
        DirectoryScanner ds = fs.getDirectoryScanner(antProject);
        String[] includedFiles = ds.getIncludedFiles();
        File prevDir = this.getPreviousJapexReport(build);
        boolean hasRegressionReport = false;
        for (String f : includedFiles) {
            String configName;
            File file = new File(ds.getBasedir(), f);
            if (file.lastModified() < build.getTimestamp().getTimeInMillis()) {
                listener.getLogger().println("Ignoring old file: " + file);
                continue;
            }
            listener.getLogger().println(file);
            try {
                TestSuiteReport rpt = new TestSuiteReport(file);
                configName = ((String)rpt.getParameters().get("configFile")).replace('/', '.');
            }
            catch (Exception e) {
                e.printStackTrace(listener.error(e.getMessage()));
                continue;
            }
            Util.copyFile((File)file, (File)new File(outDir, configName));
            File previousConfig = new File(prevDir, configName);
            if (!previousConfig.exists()) continue;
            try {
                File regressionFile = new File(outDir, configName + ".regression");
                RegressionDetector regd = new RegressionDetector();
                regd.setOldReport(previousConfig);
                regd.setNewReport(file);
                regd.setThreshold(this.regressionThreshold);
                regd.generateXmlReport(regressionFile);
                hasRegressionReport = true;
                if (!this.trackRegressions || !regd.checkThreshold((Source)new StreamSource(regressionFile))) continue;
                listener.getLogger().println("Regression detected to " + configName);
                listener.getLogger().println("Notifying " + this.regressionAddress);
                build.setResult(hudson.model.Result.UNSTABLE);
                StringWriter html = new StringWriter();
                regd.generateHtmlReport((Source)new StreamSource(regressionFile), (Result)new StreamResult(html));
                this.sendNotification(build, listener, html.toString());
            }
            catch (IOException e) {
                e.printStackTrace(listener.error("Failed to compute japex regression report for " + configName));
            }
        }
        if (hasRegressionReport) {
            build.getActions().add(new JapexReportBuildAction((Build)build));
        }
        return true;
    }

    private void sendNotification(AbstractBuild<?, ?> build, BuildListener listener, String payload) {
        try {
            MimeMessage msg = new MimeMessage(Mailer.descriptor().createSession());
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.getRegressionAddress(), (boolean)false));
            msg.setFrom((Address)new InternetAddress(Mailer.descriptor().getAdminAddress()));
            msg.setSubject("Japex performance regression in " + build.getProject().getFullDisplayName() + ' ' + build.getDisplayName());
            msg.setText(payload);
            msg.setHeader("Content-Type", "text/html");
            Transport.send((Message)msg);
        }
        catch (MessagingException e) {
            e.printStackTrace(listener.error("Failed to send out Japex notification e-mail"));
        }
    }

    private File getPreviousJapexReport(AbstractBuild<?, ?> build) {
        if ((build = (AbstractBuild)build.getPreviousNotFailedBuild()) == null) {
            return null;
        }
        return JapexPublisher.getJapexReport(build);
    }

    static File getJapexReport(AbstractBuild<?, ?> build) {
        return new File(build.getRootDir(), "japex");
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return project instanceof Project ? new JapexReportAction((Project)project) : null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(JapexPublisher.class);
        }

        public String getDisplayName() {
            return "Record Japex test report";
        }

        public String getHelpFile() {
            return "/plugin/japex/help.html";
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JapexPublisher pub = new JapexPublisher();
            req.bindParameters((Object)pub, "japex.");
            if (pub.isTrackRegressions()) {
                if (pub.getRegressionAddress() == null) {
                    throw new Descriptor.FormException("No e-mail address is set", "japex.trackRegressions");
                }
                try {
                    InternetAddress.parse((String)pub.getRegressionAddress(), (boolean)false);
                }
                catch (AddressException e) {
                    throw new Descriptor.FormException("Invalid e-mail format", (Throwable)e, "japex.trackRegressions");
                }
            }
            return pub;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return Project.class.isAssignableFrom(jobType);
        }

        public FormValidation doCheckAddress(@QueryParameter String value) {
            try {
                InternetAddress.parse((String)value, (boolean)true);
                return FormValidation.ok();
            }
            catch (AddressException e) {
                return FormValidation.error((String)"Not a valid e-mail address(es)");
            }
        }
    }
}

