/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.javanet_uploader;

import hudson.Launcher;
import hudson.Util;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.javanet_uploader.Entry;
import hudson.tasks.Publisher;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kohsuke.jnt.JNFile;
import org.kohsuke.jnt.JNFileFolder;
import org.kohsuke.jnt.JNProject;
import org.kohsuke.jnt.JavaNet;
import org.kohsuke.jnt.ProcessingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNUploaderPublisher
extends Publisher {
    private String project;
    private final List<Entry> entries = new ArrayList();
    public static final Descriptor<Publisher> DESCRIPTOR = new /* Unavailable Anonymous Inner Class!! */;

    JNUploaderPublisher() {
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public boolean perform(Build build, Launcher launcher, BuildListener listener) {
        if (build.getResult() == Result.FAILURE) {
            return true;
        }
        try {
            listener.getLogger().println("Connecting to java.net");
            JavaNet jn = JavaNet.connect();
            JNProject project = jn.getProject(this.project);
            if (!project.exists()) {
                listener.error("No such project exists: " + project);
                build.setResult(Result.FAILURE);
                return true;
            }
            Map envVars = build.getEnvVars();
            for (Entry e : this.entries) {
                String folderPath = Util.replaceMacro((String)e.getFilePath(), (Map)envVars);
                int idx = folderPath.lastIndexOf(47);
                listener.getLogger().println("Uploading " + e.getSourceFile() + " to java.net");
                if (idx < 0) {
                    throw new ProcessingException(folderPath + " doesn't have a file name");
                }
                String fileName = folderPath.substring(idx + 1);
                JNFileFolder folder = project.getFolder(folderPath = folderPath.substring(0, idx));
                if (folder == null) {
                    throw new ProcessingException("No such folder " + folderPath + " on project " + this.project);
                }
                File local = new File(build.getProject().getWorkspace().getLocal(), Util.replaceMacro((String)e.getSourceFile(), (Map)envVars));
                if (!local.exists()) {
                    throw new ProcessingException("No such file exists locally: " + local);
                }
                JNFile file = (JNFile)folder.getFiles().get(fileName);
                if (file != null) {
                    file.delete();
                }
                folder.uploadFile(fileName, Util.replaceMacro((String)e.getDescription(), (Map)envVars), e.getStatus(), local);
            }
        }
        catch (ProcessingException e) {
            e.printStackTrace(listener.error("Failed to access java.net"));
            build.setResult(Result.FAILURE);
        }
        return true;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }
}

