/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.javanet_uploader;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.javanet_uploader.Entry;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kohsuke.jnt.FileStatus;
import org.kohsuke.jnt.JNFile;
import org.kohsuke.jnt.JNFileFolder;
import org.kohsuke.jnt.JNProject;
import org.kohsuke.jnt.JavaNet;
import org.kohsuke.jnt.ProcessingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNUploaderPublisher
extends Publisher {
    private String project;
    private final List<Entry> entries = new ArrayList();
    public static final Descriptor<Publisher> DESCRIPTOR = new /* Unavailable Anonymous Inner Class!! */;

    JNUploaderPublisher() {
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public boolean perform(Build build, Launcher launcher, BuildListener listener) throws InterruptedException {
        if (build.getResult() == Result.FAILURE) {
            return true;
        }
        try {
            listener.getLogger().println("Connecting to java.net");
            JavaNet jn = JavaNet.connect();
            JNProject project = jn.getProject(this.project);
            if (!project.exists()) {
                listener.error("No such project exists: " + project);
                build.setResult(Result.FAILURE);
                return true;
            }
            Map envVars = build.getEnvVars();
            for (Entry e : this.entries) {
                JNFileFolder folder;
                String folderPath;
                listener.getLogger().println("Uploading " + e.sourceFile + " to java.net");
                String expanded = Util.replaceMacro((String)e.sourceFile, (Map)envVars);
                FilePath[] src = ((Project)build.getProject()).getWorkspace().list(expanded);
                if (src.length == 0) {
                    throw new ProcessingException("No such file exists: " + expanded);
                }
                if (src.length == 1) {
                    folderPath = Util.replaceMacro((String)e.filePath, (Map)envVars);
                    folder = project.getFolder(folderPath);
                    if (folder != null) {
                        this.upload(folder, src[0].getName(), src[0], e, envVars);
                        continue;
                    }
                    int idx = folderPath.lastIndexOf(47);
                    if (idx < 0) {
                        throw new ProcessingException(folderPath + " doesn't have a file name");
                    }
                    String fileName = folderPath.substring(idx + 1);
                    folderPath = folderPath.substring(0, idx);
                    folder = this.getFolder(project, folderPath);
                    this.upload(folder, fileName, src[0], e, envVars);
                    continue;
                }
                folderPath = Util.replaceMacro((String)e.filePath, (Map)envVars);
                folder = this.getFolder(project, folderPath);
                for (FilePath s : src) {
                    this.upload(folder, s.getName(), s, e, envVars);
                }
            }
        }
        catch (ProcessingException e) {
            e.printStackTrace(listener.error("Failed to access java.net"));
            build.setResult(Result.FAILURE);
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to upload files"));
            build.setResult(Result.FAILURE);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(JNFileFolder folder, String fileName, FilePath src, Entry e, Map<String, String> envVars) throws ProcessingException, IOException {
        JNFile file = (JNFile)folder.getFiles().get(fileName);
        if (file != null) {
            file.delete();
        }
        InputStream in = src.read();
        try {
            folder.uploadFile(fileName, Util.replaceMacro((String)e.description, envVars), FileStatus.parse((String)e.status), in, "application/octet-stream");
        }
        finally {
            in.close();
        }
    }

    private JNFileFolder getFolder(JNProject project, String folderPath) throws ProcessingException {
        JNFileFolder folder = project.getFolder(folderPath);
        if (folder == null) {
            throw new ProcessingException("No such folder " + folderPath + " on project " + this.project);
        }
        return folder;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }
}

