/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.javanet;

import hudson.model.AbstractProject;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.javanet.JavaNetStatsAction;
import hudson.plugins.javanet.StatsProperty;
import hudson.scm.CVSSCM;
import hudson.scm.SCM;
import hudson.scm.SubversionSCM;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsProperty
extends JobProperty<AbstractProject<?, ?>> {
    private static final Pattern SVN_URL = Pattern.compile("https://[^.]+.dev.java.net/svn/([^/]+)(/.*)?");
    private static final String USERNAME = "([A-Za-z0-9_\\-])+";
    private static final String HOST = "(.*.dev.java.net|kohsuke.sfbay.*)";
    private static final Pattern CVS_URL = Pattern.compile(":pserver:([A-Za-z0-9_\\-])+@(.*.dev.java.net|kohsuke.sfbay.*):/cvs");
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl(null);

    public JobPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public JavaNetStatsAction getJobAction(AbstractProject<?, ?> job) {
        String jnp = this.getJavaNetProject(job);
        if (jnp == null) {
            return null;
        }
        return new JavaNetStatsAction(job, jnp);
    }

    private String getJavaNetProject(AbstractProject<?, ?> job) {
        return this.getJavaNetProject(job.getScm());
    }

    private String getJavaNetProject(SCM scm) {
        CVSSCM cscm;
        if (scm instanceof SubversionSCM) {
            SubversionSCM sscm = (SubversionSCM)scm;
            for (SubversionSCM.ModuleLocation loc : sscm.getLocations()) {
                Matcher m = SVN_URL.matcher(loc.remote);
                if (!m.matches()) continue;
                return m.group(1);
            }
        }
        if (scm instanceof CVSSCM && CVS_URL.matcher((cscm = (CVSSCM)scm).getCvsRoot()).matches()) {
            StringTokenizer tokens = new StringTokenizer(cscm.getAllModules(), " /\\");
            return tokens.nextToken();
        }
        return null;
    }
}

