/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.javanet;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.plugins.javanet.ReportGenerator;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaNetStatsAction
implements Action {
    public final AbstractProject<?, ?> project;
    private final String projectName;
    private final File reportDir;
    private static final Pattern PATH = Pattern.compile("[A-Za-z0-9\\-.]+");

    public JavaNetStatsAction(AbstractProject<?, ?> project, String projectName) {
        this.project = project;
        this.projectName = projectName;
        this.reportDir = this.getReportDirectory();
    }

    public void scheduleGeneration() {
        new ReportGenerator(this.projectName, this.reportDir).schedule();
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return "java.net statistics";
    }

    public String getUrlName() {
        return "java.net-stats";
    }

    public boolean isReportReady() {
        return new File(this.reportDir, "index.html").exists();
    }

    public void upToDateCheck() {
        File indexHtml = new File(this.reportDir, "index.html");
        if (!indexHtml.exists() || System.currentTimeMillis() - indexHtml.lastModified() > 14515200000L) {
            this.scheduleGeneration();
        }
    }

    public URL getIssueStatsIndexHtml() {
        return this.getClass().getClassLoader().getResource("org/jvnet/its/index.html");
    }

    private File getReportDirectory() {
        return new File(Hudson.getInstance().getRootDir(), "java.net/issue-tracker-stats/" + this.projectName);
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        String path = req.getRestOfPath().substring(1);
        if (!PATH.matcher(path).matches()) {
            rsp.sendError(404);
            return;
        }
        rsp.serveFile(req, new File(this.reportDir, path).toURL());
    }
}

