/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.javanet;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.plugins.javanet.ReportGenerator;
import hudson.security.Permission;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.apache.commons.io.FileUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaNetStatsAction
implements Action {
    public final AbstractProject<?, ?> project;
    private String projectName;
    private File reportDir;
    private static final Pattern PATH = Pattern.compile("[A-Za-z0-9\\-.]+");
    public static final Permission CONFIGURE = Permission.CONFIGURE;

    public JavaNetStatsAction(AbstractProject<?, ?> project, String projectName) {
        this.project = project;
        this.projectName = projectName;
        this.reportDir = this.getReportDirectory();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void scheduleGeneration() {
        new ReportGenerator(this.projectName, this.reportDir).schedule();
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return "Java.net Statistics";
    }

    public String getUrlName() {
        return "java.net-stats";
    }

    public boolean isReportReady() {
        return new File(this.reportDir, "index.html").exists();
    }

    public void upToDateCheck() {
        File indexHtml = new File(this.reportDir, "index.html");
        long diff = System.currentTimeMillis() - indexHtml.lastModified();
        if (!indexHtml.exists() || diff > 604800000L) {
            this.scheduleGeneration();
        }
    }

    public URL getIssueStatsIndexHtml() {
        return this.getClass().getClassLoader().getResource("org/jvnet/its/index.html");
    }

    private File getReportDirectory() {
        return new File(Hudson.getInstance().getRootDir(), "java.net/issue-tracker-stats/" + this.projectName);
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        String path = req.getRestOfPath().substring(1);
        if (!PATH.matcher(path).matches()) {
            rsp.sendError(404);
            return;
        }
        rsp.serveFile(req, new File(this.reportDir, path).toURL());
    }

    public void doChangeProject(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="name") String name) throws IOException, ServletException {
        this.project.checkPermission(CONFIGURE);
        this.projectName = name.trim();
        this.reportDir = this.getReportDirectory();
        FileUtils.writeStringToFile((File)this.getOverrideFile(), (String)this.projectName, (String)"UTF-8");
        rsp.sendRedirect2(".");
    }

    public void doRegenerate(StaplerResponse rsp) throws IOException, ServletException {
        this.scheduleGeneration();
        rsp.sendRedirect2(".");
    }

    public boolean hasConfigurePermission() {
        return this.project.hasPermission(CONFIGURE);
    }

    private File getOverrideFile() {
        return new File(this.project.getRootDir(), "java.net.projectName");
    }

    static String readOverrideFile(AbstractProject<?, ?> project) {
        try {
            return FileUtils.readFileToString((File)new File(project.getRootDir(), "java.net.projectName"), (String)"UTF-8").trim();
        }
        catch (IOException e) {
            return null;
        }
    }
}

