/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.javanet;

import hudson.util.DaemonThreadFactory;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.its.Generator;
import org.kohsuke.jnt.JavaNet;
import org.kohsuke.jnt.ProcessingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReportGenerator
implements Runnable {
    private final String projectName;
    private final File reportDir;
    static final ExecutorService EXECUTOR = Executors.newFixedThreadPool(1, (ThreadFactory)new DaemonThreadFactory());
    private static final Logger LOGGER = Logger.getLogger(ReportGenerator.class.getName());

    ReportGenerator(String projectName, File reportDir) {
        this.projectName = projectName;
        this.reportDir = reportDir;
    }

    public Future<?> schedule() {
        return EXECUTOR.submit((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Generator gen = new Generator();
        long start = System.currentTimeMillis();
        LOGGER.info("Starting to generate java.net issue tracker stats for " + this.projectName);
        String oldName = Thread.currentThread().getName();
        Thread.currentThread().setName("java.net issue tracker stat generation for " + this.projectName);
        this.reportDir.mkdirs();
        try {
            gen.generate(JavaNet.connect().getProject(this.projectName), this.reportDir);
        }
        catch (ProcessingException e) {
            LOGGER.log(Level.SEVERE, "Failed to generate java.net stat report for " + this.projectName, e);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to generate java.net stat report for " + this.projectName, e);
        }
        finally {
            Thread.currentThread().setName(oldName);
        }
        LOGGER.info(MessageFormat.format("Completed generating java.net issue tracker stats for {0} in {1} ms", this.projectName, System.currentTimeMillis() - start));
    }
}

