/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.javanet;

import hudson.Plugin;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.JobProperty;
import hudson.model.Jobs;
import hudson.model.listeners.ItemListener;
import hudson.plugins.javanet.JavaNetStatsAction;
import hudson.plugins.javanet.StatsProperty;
import hudson.triggers.SafeTimerTask;
import hudson.triggers.Trigger;
import java.io.IOException;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PluginImpl
extends Plugin {
    static final long SEC = 1000L;
    static final long MINUTE = 60000L;
    static final long HOUR = 3600000L;
    static final long DAY = 86400000L;
    private static final Logger LOGGER = Logger.getLogger(PluginImpl.class.getName());
    static final boolean debug = Boolean.getBoolean(PluginImpl.class.getName() + ".debug");

    public void start() {
        Jobs.PROPERTIES.add(StatsProperty.DESCRIPTOR);
        Hudson.getInstance().getJobListeners().add((Object)new ItemListener(){

            public void onLoaded() {
                for (AbstractProject j : Hudson.getInstance().getAllItems(AbstractProject.class)) {
                    StatsProperty p = (StatsProperty)j.getProperty(StatsProperty.class);
                    if (p != null) continue;
                    try {
                        j.addProperty((JobProperty)new StatsProperty());
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, "Failed to persist " + j, e);
                    }
                }
                Trigger.timer.scheduleAtFixedRate((TimerTask)new SafeTimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void doRun() {
                        LOGGER.fine("Starting up-to-date check of java.net stat reports");
                        long startTime = System.currentTimeMillis();
                        try {
                            for (AbstractProject j : Hudson.getInstance().getAllItems(AbstractProject.class)) {
                                JavaNetStatsAction a;
                                StatsProperty p = (StatsProperty)j.getProperty(StatsProperty.class);
                                if (p == null || (a = p.getJobAction(j)) == null) continue;
                                a.upToDateCheck();
                            }
                        }
                        finally {
                            LOGGER.fine("Completing up-to-date check of java.net stat reports. Took " + (System.currentTimeMillis() - startTime) + "ms");
                        }
                    }
                }, debug ? 15000L : 600000L, debug ? 15000L : 10800000L);
            }
        });
    }
}

