/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.javatest_report;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.javatest_report.Status;
import hudson.plugins.javatest_report.TestCollection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestObject<S extends TestObject<S>>
implements ModelObject {
    private String id;
    private String name;
    private String description;
    private Status status;
    private String statusMessage;
    private Map<String, String> attributes;
    TestCollection parent;
    private int failedSince;

    TestObject() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id.replace(':', '.');
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public final String getDisplayName() {
        if (this.name != null) {
            if (this.name.equals("unknown")) {
                return this.id.substring(7);
            }
            return this.name;
        }
        return this.id;
    }

    public AbstractBuild getOwner() {
        return this.parent.getOwner();
    }

    public int getFailedSince() {
        if (!this.isPassed() && this.failedSince == 0) {
            TestObject prev = this.getPreviousResult();
            this.failedSince = prev != null && !prev.isPassed() ? prev.failedSince : this.getOwner().getNumber();
        }
        return this.failedSince;
    }

    private boolean isPassed() {
        return this.getStatus() == Status.PASS;
    }

    public int getAge() {
        if (this.isPassed()) {
            return 0;
        }
        return this.getOwner().getNumber() - this.failedSince + 1;
    }

    public S getPreviousResult() {
        TestCollection p = (TestCollection)this.parent.getPreviousResult();
        if (p != null) {
            return (S)p.get(this.getId());
        }
        return null;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatusString(String status) {
        this.status = status.equalsIgnoreCase("pass") ? Status.PASS : (status.equalsIgnoreCase("did_not_run") ? Status.SKIP : (status.equalsIgnoreCase("error") ? Status.ERROR : Status.FAIL));
    }

    public void addAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, value);
        if (name.equals("logfile")) {
            this.statusMessage = value;
        }
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public abstract int getTotalCount();

    public abstract int getFailCount();

    public abstract int getSkippedCount();
}

