/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.javatest_report;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.javatest_report.JavaTestAction;
import hudson.plugins.javatest_report.Report;
import hudson.remoting.VirtualChannel;
import hudson.tasks.Publisher;
import hudson.tasks.test.TestResultProjectAction;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTestReportPublisher
extends Publisher
implements Serializable {
    private final String includes;
    private final String jtwork;
    private static final long serialVersionUID = 1L;

    public JavaTestReportPublisher(String includes, String jtwork) {
        this.includes = includes;
        this.jtwork = jtwork;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getJtwork() {
        return this.jtwork;
    }

    public Action getProjectAction(Project project) {
        return new TestResultProjectAction((AbstractProject)project);
    }

    public boolean perform(Build build, Launcher launcher, final BuildListener listener) throws IOException, InterruptedException {
        final long buildTime = build.getTimestamp().getTimeInMillis();
        this.archiveJTWork(build, listener);
        listener.getLogger().println("Collecting Java Test reports");
        File dataDir = JavaTestAction.getDataDir((AbstractBuild)build);
        dataDir.mkdirs();
        final FilePath target = new FilePath(dataDir);
        try {
            build.getProject().getWorkspace().act((FilePath.FileCallable)new FilePath.FileCallable<Void>(){
                private static final long serialVersionUID = 1L;

                public Void invoke(File ws, VirtualChannel channel) throws IOException {
                    FileSet fs = new FileSet();
                    org.apache.tools.ant.Project p = new org.apache.tools.ant.Project();
                    fs.setProject(p);
                    fs.setDir(ws);
                    fs.setIncludes(JavaTestReportPublisher.this.includes);
                    String[] includedFiles = fs.getDirectoryScanner(p).getIncludedFiles();
                    if (includedFiles.length == 0) {
                        throw new AbortException("No Java test report files were found. Configuration error?");
                    }
                    int counter = 0;
                    for (String file : includedFiles) {
                        File src = new File(ws, file);
                        if (src.lastModified() < buildTime) {
                            listener.getLogger().println("Skipping " + src + " because it's not up to date");
                            continue;
                        }
                        try {
                            new FilePath(src).copyTo(target.child("report" + counter++ + ".xml"));
                        }
                        catch (InterruptedException e) {
                            throw new IOException2("aborted while copying " + src, (Throwable)e);
                        }
                    }
                    return null;
                }
            });
        }
        catch (AbortException e) {
            listener.getLogger().println(e.getMessage());
            build.setResult(Result.FAILURE);
            return true;
        }
        JavaTestAction action = new JavaTestAction(build, listener);
        build.getActions().add(action);
        Report r = action.getResult();
        if (r.getTotalCount() == 0) {
            listener.getLogger().println("Test reports were found but none of them are new. Did tests run?");
            build.setResult(Result.FAILURE);
        }
        if (r.getFailCount() > 0) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    private void archiveJTWork(Build<?, ?> owner, BuildListener listener) throws IOException, InterruptedException {
        if (this.jtwork == null || this.jtwork.equals("")) {
            listener.getLogger().println("Set Java Test Work directory for better reporting");
        } else {
            Project p = (Project)owner.getProject();
            p.getWorkspace().child(this.jtwork).copyRecursiveTo("**/*", new FilePath(owner.getArtifactsDir()).child("java-test-work"));
        }
    }

    public Descriptor<Publisher> getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DescriptorImpl
    extends Descriptor<Publisher> {
        public static final Descriptor<Publisher> DESCRIPTOR = new DescriptorImpl();

        public DescriptorImpl() {
            super(JavaTestReportPublisher.class);
        }

        public String getDisplayName() {
            return "Publish JavaTest result report";
        }

        public String getHelpFile() {
            return "/plugin/javatest-report/help.html";
        }

        public Publisher newInstance(StaplerRequest req) {
            return new JavaTestReportPublisher(req.getParameter("javatest_includes"), req.getParameter("javatest_jtwork"));
        }
    }

    private static final class AbortException
    extends RuntimeException {
        public AbortException(String s) {
            super(s);
        }
    }
}

