/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.javatest_report;

import hudson.plugins.javatest_report.Status;
import hudson.plugins.javatest_report.TestObject;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestCollection<S extends TestCollection<S, C>, C extends TestObject<C>>
extends TestObject<S> {
    private final Map<String, C> tests = new TreeMap<String, C>();
    private final Map<String, C> failedTests = new TreeMap<String, C>();
    private final Map<String, C> skippedTests = new TreeMap<String, C>();
    private int totalCount;
    private int failCount;
    private int skippedCount;

    public Collection<C> getChildren() {
        return this.tests.values();
    }

    public Collection<C> getFailedTests() {
        return this.failedTests.values();
    }

    public Collection<C> getSkippedTests() {
        return this.skippedTests.values();
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }

    @Override
    public int getFailCount() {
        return this.failCount;
    }

    @Override
    public int getSkippedCount() {
        return this.skippedCount;
    }

    public abstract String getChildTitle();

    public C get(String id) {
        return (C)((TestObject)this.tests.get(id));
    }

    public void add(C t) {
        this.tests.put(((TestObject)t).getId(), t);
        if (((TestObject)t).getStatus() == Status.SKIP) {
            this.skippedTests.put(((TestObject)t).getId(), t);
        } else if (((TestObject)t).getStatus() != Status.PASS) {
            this.failedTests.put(((TestObject)t).getId(), t);
        }
        if (((TestObject)t).getStatus() != Status.SKIP) {
            this.totalCount += ((TestObject)t).getTotalCount();
        }
        this.failCount += ((TestObject)t).getFailCount();
        this.skippedCount += ((TestObject)t).getSkippedCount();
        ((TestObject)t).parent = this;
    }

    public C getDynamic(String name, StaplerRequest req, StaplerResponse rsp) {
        return this.get(name);
    }
}

