/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.javatest_report;

import hudson.model.AbstractBuild;
import hudson.plugins.javatest_report.JavaTestAction;
import hudson.plugins.javatest_report.Suite;
import hudson.plugins.javatest_report.Test;
import hudson.plugins.javatest_report.TestCase;
import hudson.plugins.javatest_report.TestCollection;
import java.io.File;
import java.io.IOException;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Report
extends TestCollection<Report, Suite> {
    private final JavaTestAction owner;

    public Report(JavaTestAction owner) {
        this.owner = owner;
        this.setName("JavaTest Result");
        this.setId("root");
    }

    @Override
    public AbstractBuild getOwner() {
        return this.owner.owner;
    }

    @Override
    public Report getPreviousResult() {
        JavaTestAction p = (JavaTestAction)this.owner.getPreviousResult();
        if (p != null) {
            return p.getResult();
        }
        return null;
    }

    @Override
    public void add(File reportXml) throws IOException, SAXException {
        Digester digester = new Digester();
        digester.setClassLoader(this.getClass().getClassLoader());
        digester.push((Object)this);
        digester.addObjectCreate("*/testsuite", Suite.class);
        digester.addObjectCreate("*/test", Test.class);
        digester.addObjectCreate("*/testcase", TestCase.class);
        digester.addSetNext("*/testsuite", "add");
        digester.addSetNext("*/test", "add");
        digester.addSetNext("*/testcase", "add");
        digester.addSetProperties("*/testsuite");
        digester.addSetProperties("*/test");
        digester.addSetProperties("*/testcase");
        digester.addBeanPropertySetter("*/name");
        digester.addBeanPropertySetter("*/description");
        digester.addSetProperties("*/status", "value", "statusString");
        digester.addCallMethod("*/attribute", "addAttribute", 2);
        digester.addCallParam("*/attribute/name", 0);
        digester.addCallParam("*/attribute/value", 1);
        digester.setValidating(false);
        digester.parse(reportXml);
    }

    @Override
    public String getChildTitle() {
        return "Test Suite";
    }
}

