/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.javatest_report;

import hudson.plugins.javatest_report.Package;
import hudson.plugins.javatest_report.Status;
import hudson.plugins.javatest_report.Suite;
import hudson.plugins.javatest_report.Test;
import hudson.plugins.javatest_report.TestObject;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestCollection<S extends TestCollection<S, C>, C extends TestObject<C>>
extends TestObject<S> {
    private final Map<String, C> tests = new TreeMap<String, C>();
    private final Map<String, C> failedTests = new TreeMap<String, C>();
    private final Map<String, C> skippedTests = new TreeMap<String, C>();
    private final Map<String, Package> packages = new TreeMap<String, Package>();
    private int totalCount;
    private int failCount;
    private int skippedCount;

    public Collection<C> getChildren() {
        return this.tests.values();
    }

    public Collection<C> getFailedTests() {
        return this.failedTests.values();
    }

    public Collection<C> getSkippedTests() {
        return this.skippedTests.values();
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }

    @Override
    public int getFailCount() {
        return this.failCount;
    }

    @Override
    public int getSkippedCount() {
        return this.skippedCount;
    }

    public abstract String getChildTitle();

    public C get(String id) {
        return (C)((TestObject)this.tests.get(id));
    }

    public void add(C t) {
        this.tests.put(((TestObject)t).getId(), t);
        if (((TestObject)t).getStatus() == Status.SKIP) {
            this.skippedTests.put(((TestObject)t).getId(), t);
        } else if (((TestObject)t).getStatus() != Status.PASS) {
            this.failedTests.put(((TestObject)t).getId(), t);
        }
        if (((TestObject)t).getStatus() != Status.SKIP) {
            this.totalCount += ((TestObject)t).getTotalCount();
        }
        this.failCount += ((TestObject)t).getFailCount();
        this.skippedCount += ((TestObject)t).getSkippedCount();
        ((TestObject)t).parent = this;
        if (((TestObject)t).getStatus() == Status.SKIP || !this.getClass().isAssignableFrom(Suite.class)) {
            return;
        }
        String fqcn = ((TestObject)t).getName();
        int packagePosition = fqcn.lastIndexOf("/");
        if (packagePosition > 0 && packagePosition < fqcn.length()) {
            Test test = new Test();
            test.setId(((TestObject)t).getId());
            test.setName(((TestObject)t).getName());
            test.setStatusString(((TestObject)t).getStatus().toString());
            test.setDescription(((TestObject)t).getDescription());
            test.addAttribute("logfile", ((TestObject)t).getStatusMessage());
            String packageName = fqcn.substring(0, packagePosition).replaceAll("/", ".");
            String testName = fqcn.substring(packagePosition + 1, fqcn.length());
            Package c = this.packages.get(packageName);
            if (c != null) {
                c.add(test);
            } else {
                Package newSuite = new Package();
                newSuite.setId(packageName);
                newSuite.setName(packageName);
                newSuite.add(test);
                newSuite.parent = this;
                this.packages.put(packageName, newSuite);
            }
        }
    }

    public String[] getPackages() {
        if (this.packages == null) {
            System.out.println("null" + this.getClass() + this.toString());
            return null;
        }
        Set<String> set = this.packages.keySet();
        String[] strs = new String[set.size()];
        strs = set.toArray(strs);
        return strs;
    }

    public Package getPackageTests(String packageName) {
        return this.packages.get(packageName);
    }

    public C getDynamic(String name, StaplerRequest req, StaplerResponse rsp) {
        return this.get(name);
    }
}

