/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.javatest_report;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.javatest_report.JavaTestAction;
import hudson.plugins.javatest_report.JavaTestReportPublisher;
import hudson.plugins.javatest_report.Report;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.test.TestResultProjectAction;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTestReportPublisher
extends Recorder
implements Serializable {
    private final String includes;
    private final String jtwork;
    private static final long serialVersionUID = 1L;

    public JavaTestReportPublisher(String includes, String jtwork) {
        this.includes = includes;
        this.jtwork = jtwork;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getJtwork() {
        return this.jtwork;
    }

    public Action getProjectAction(Project project) {
        return new TestResultProjectAction((AbstractProject)project);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        this.archiveJTWork(build, listener);
        listener.getLogger().println("Collecting JavaTest reports");
        File dataDir = JavaTestAction.getDataDir(build);
        dataDir.mkdirs();
        FilePath target = new FilePath(dataDir);
        long buildTime = build.getTimestamp().getTimeInMillis();
        long nowMaster = System.currentTimeMillis();
        try {
            build.getWorkspace().act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (AbortException e) {
            listener.getLogger().println(e.getMessage());
            build.setResult(Result.FAILURE);
            return true;
        }
        JavaTestAction action = new JavaTestAction(build, listener);
        build.getActions().add(action);
        Report r = action.getResult();
        if (r.getTotalCount() == 0) {
            listener.getLogger().println("Test reports were found but none of them are new. Did tests run?");
            build.setResult(Result.FAILURE);
        }
        if (r.getFailCount() > 0) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    private void archiveJTWork(AbstractBuild<?, ?> owner, BuildListener listener) throws IOException, InterruptedException {
        if (this.jtwork == null || this.jtwork.equals("")) {
            listener.getLogger().println("Set JavaTest Work directory for better reporting");
        } else {
            owner.getWorkspace().child(this.jtwork).copyRecursiveTo("**/*", new FilePath(owner.getArtifactsDir()).child("java-test-work"));
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    static /* synthetic */ String access$000(JavaTestReportPublisher x0) {
        return x0.includes;
    }
}

