/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.javatest_report;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.javatest_report.Report;
import hudson.tasks.test.AbstractTestResultAction;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerProxy;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTestAction
extends AbstractTestResultAction<JavaTestAction>
implements StaplerProxy {
    private transient WeakReference<Report> result;
    private int failCount;
    private int totalCount;
    private static final Logger logger = Logger.getLogger(JavaTestAction.class.getName());

    JavaTestAction(AbstractBuild<?, ?> owner, BuildListener listener) {
        super(owner);
        Report r = this.load(listener);
        this.totalCount = r.getTotalCount();
        this.failCount = r.getFailCount();
        this.result = new WeakReference<Report>(r);
    }

    static File getDataDir(AbstractBuild<?, ?> build) {
        return new File(build.getRootDir(), "java-test-result");
    }

    public synchronized Report getResult() {
        if (this.result == null) {
            Report r = this.load(null);
            this.result = new WeakReference<Report>(r);
            return r;
        }
        Report r = (Report)this.result.get();
        if (r == null) {
            r = this.load(null);
            this.result = new WeakReference<Report>(r);
        }
        return r;
    }

    public int getFailCount() {
        return this.failCount;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    private Report load(BuildListener listener) {
        Report r = new Report(this);
        File[] files = JavaTestAction.getDataDir(this.owner).listFiles();
        if (files == null) {
            logger.log(Level.WARNING, "No test reports found in " + JavaTestAction.getDataDir(this.owner));
            return r;
        }
        for (File f : files) {
            try {
                if (!f.isFile() || !f.getName().endsWith(".xml")) continue;
                r.add(f);
            }
            catch (IOException e) {
                if (listener != null) {
                    e.printStackTrace(listener.error("Failed to parse " + f));
                    continue;
                }
                logger.log(Level.WARNING, "Failed to load " + f, e);
            }
            catch (SAXException e) {
                if (listener != null) {
                    e.printStackTrace(listener.error("Failed to parse " + f));
                    continue;
                }
                logger.log(Level.WARNING, "Failed to load " + f, e);
            }
        }
        return r;
    }

    public Object getTarget() {
        return this.getResult();
    }
}

