/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jdepend;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.plugins.jdepend.JDependParser;
import hudson.plugins.jdepend.JDependReporter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDependBuildAction
implements Action {
    public final AbstractBuild<?, ?> build;
    private final JDependParser jDependParser;
    private String htmlReport;

    public JDependBuildAction(AbstractBuild<?, ?> build, JDependParser jDependParser) {
        this.build = build;
        this.jDependParser = jDependParser;
        JDependReporter r = new JDependReporter(jDependParser);
        try {
            this.htmlReport = r.getReport();
        }
        catch (Exception e) {
            this.htmlReport = "Report generation failed: " + e;
        }
    }

    public String getDisplayName() {
        return "JDepend";
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "jdepend";
    }

    public String getJDependHtml() {
        Pattern trimTop = Pattern.compile("^.*<body>", 42);
        Pattern trimBottom = Pattern.compile("</body>.*</html>", 42);
        Matcher topMatcher = trimTop.matcher(this.htmlReport);
        this.htmlReport = topMatcher.replaceAll("");
        Matcher bottomMatcher = trimBottom.matcher(this.htmlReport);
        this.htmlReport = bottomMatcher.replaceAll("");
        return this.htmlReport;
    }

    public JDependParser getJDependParser() {
        return this.jDependParser;
    }
}

