/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jdepend;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.jdepend.JDependBuildAction;
import hudson.plugins.jdepend.JDependParser;
import hudson.plugins.jdepend.JDependProjectAction;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import jdepend.xmlui.JDepend;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDependRecorder
extends Recorder {
    private transient PrintStream logger = System.out;
    private String configuredJDependFile = null;

    @DataBoundConstructor
    public JDependRecorder(String configuredJDependFile) {
        this.configuredJDependFile = configuredJDependFile;
    }

    protected void log(String message) {
        this.logger.println("[JDepend] " + message);
    }

    public JDependParser getConfiguredParser(AbstractBuild<?, ?> build, String configuredPath) {
        JDependParser p = null;
        try {
            if (configuredPath.startsWith("/")) {
                File xmlFile = new File(configuredPath);
                p = this.getJDependParser(xmlFile);
            } else {
                File tempJDependFile = File.createTempFile("jdepend", ".xml");
                build.getWorkspace().withSuffix("/" + configuredPath).copyTo((OutputStream)new FileOutputStream(tempJDependFile));
                p = this.getJDependParser(tempJDependFile);
                if (!tempJDependFile.delete()) {
                    this.log("Unable to remove temp JDepend file in " + tempJDependFile.getPath());
                }
            }
        }
        catch (Exception e) {
            this.log("Couldn't generate JDepend file at '" + this.configuredJDependFile + "'" + e);
        }
        return p;
    }

    private FilePath copyToLocalWorkspace(FilePath currentWorkspace) throws InterruptedException, IOException {
        FilePath newSourceLocation = new FilePath(new File(System.getProperty("java.io.tmpdir"))).createTempDir("hudson-jdepend", "");
        this.log("Copying remote data to " + newSourceLocation.toURI());
        currentWorkspace.copyRecursiveTo(newSourceLocation);
        this.log("Copy complete");
        return newSourceLocation;
    }

    protected JDependParser getJDependParser(File jDependOutputFile, String sourcePath) throws IOException, ParserConfigurationException, SAXException {
        this.log("Starting JDepend file, outputting to " + jDependOutputFile.getAbsolutePath());
        JDepend.main((String[])this.getArgumentList("-file", jDependOutputFile.getAbsolutePath(), sourcePath));
        return this.getJDependParser(jDependOutputFile);
    }

    protected JDependParser getJDependParser(File jDependExistingFile) throws ParserConfigurationException, SAXException, IOException {
        JDependParser xmlParser = new JDependParser(jDependExistingFile);
        this.log("Found " + xmlParser.getTotalClasses() + " classes in " + xmlParser.getPackages().size() + " packages");
        return xmlParser;
    }

    protected boolean generateJDependReport(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        this.logger = listener.getLogger();
        File jDependFile = null;
        String sourcePath = ".";
        FilePath sourceLocation = build.getProject().getWorkspace();
        boolean copiedWorkspace = false;
        JDependParser p = null;
        this.log("JDepend plugin is ready");
        if (this.configuredJDependFile != null && !this.configuredJDependFile.matches("(\\s)?")) {
            p = this.getConfiguredParser(build, this.configuredJDependFile);
            build.getActions().add(new JDependBuildAction(build, p));
            return true;
        }
        try {
            if (sourceLocation.isRemote()) {
                sourceLocation = this.copyToLocalWorkspace(sourceLocation);
                copiedWorkspace = true;
            }
            jDependFile = File.createTempFile("jdepend", ".xml");
        }
        catch (Exception e) {
            this.log("Unable to ready files: " + e);
            return false;
        }
        try {
            sourcePath = sourceLocation.toURI().getPath();
        }
        catch (Exception e) {
            this.log("Unable to get workspace path: " + e);
            return false;
        }
        try {
            p = this.getJDependParser(jDependFile, sourcePath);
        }
        catch (Exception e) {
            this.log("Couldn't generate JDepend file " + e);
        }
        build.getActions().add(new JDependBuildAction(build, p));
        if (copiedWorkspace) {
            try {
                this.log("Temporary directory deletion disabled, due to lack of testing. Your OS should clean the directory later. If this is a problem, please submit a bug report.");
            }
            catch (Exception e) {
                this.log("Unable to remove copied temp source directory at " + sourcePath + ": " + e);
            }
        }
        if (!jDependFile.delete()) {
            this.log("Unable to remove temp JDepend file in " + jDependFile.getPath());
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        return this.generateJDependReport(build, launcher, listener);
    }

    private String[] getArgumentList(String argument, String reportFile, String classDir) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(argument);
        argList.add(reportFile);
        argList.add(classDir);
        return argList.toArray(new String[argList.size()]);
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new JDependProjectAction(project);
    }

    public String getConfiguredJDependFile() {
        return this.configuredJDependFile;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(JDependRecorder.class);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Report JDepend";
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            return true;
        }
    }
}

