/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jmeter;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.jmeter.JMeterBuildAction;
import hudson.plugins.jmeter.JMeterReport;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMeterProjectAction
implements Action {
    private static final long serialVersionUID = 1L;
    private final Project<?, ?> project;

    public JMeterProjectAction(Project<?, ?> project) {
        this.project = project;
    }

    private boolean checkIfGraphModified(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild build = (AbstractBuild)this.getProject().getLastBuild();
        Calendar t = build.getTimestamp();
        return request.checkIfModified(t, response);
    }

    private JFreeChart createErrorsChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart((String)"Percentage of errors", null, (String)"%", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperBound(100.0);
        rangeAxis.setLowerBound(0.0);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setStroke((Stroke)new BasicStroke(4.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private JFreeChart createRespondingTimeChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart((String)"Responding time", null, (String)"ms", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setStroke((Stroke)new BasicStroke(4.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    public void doErrorsGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        if (ChartUtil.awtProblem) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        if (this.checkIfGraphModified(request, response)) {
            return;
        }
        DataSetBuilder dataSetBuilderErrors = new DataSetBuilder();
        List builds = this.getProject().getBuilds();
        for (AbstractBuild currentBuild : builds) {
            if (!Result.SUCCESS.equals(currentBuild.getResult())) continue;
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(currentBuild);
            JMeterBuildAction jmeterBuildAction = (JMeterBuildAction)currentBuild.getAction(JMeterBuildAction.class);
            JMeterReport jmeterReport = jmeterBuildAction.getJmeterReport();
            dataSetBuilderErrors.add((Number)((double)jmeterReport.countErrors() / (double)jmeterReport.size() * 100.0), (Comparable)((Object)"errors"), (Comparable)label);
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createErrorsChart(dataSetBuilderErrors.build()), (int)400, (int)200);
    }

    public void doRespondingTimeGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        if (ChartUtil.awtProblem) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        if (this.checkIfGraphModified(request, response)) {
            return;
        }
        DataSetBuilder dataSetBuilderAverage = new DataSetBuilder();
        List builds = this.getProject().getBuilds();
        for (AbstractBuild currentBuild : builds) {
            if (!Result.SUCCESS.equals(currentBuild.getResult())) continue;
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(currentBuild);
            JMeterBuildAction jmeterBuildAction = (JMeterBuildAction)currentBuild.getAction(JMeterBuildAction.class);
            JMeterReport jmeterReport = jmeterBuildAction.getJmeterReport();
            dataSetBuilderAverage.add((Number)jmeterReport.getMax(), (Comparable)((Object)"max"), (Comparable)label);
            dataSetBuilderAverage.add((Number)jmeterReport.getAverage(), (Comparable)((Object)"average"), (Comparable)label);
            dataSetBuilderAverage.add((Number)jmeterReport.getMin(), (Comparable)((Object)"min"), (Comparable)label);
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createRespondingTimeChart(dataSetBuilderAverage.build()), (int)400, (int)200);
    }

    public String getDisplayName() {
        return "JMeter trend";
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public Project<?, ?> getProject() {
        return this.project;
    }

    public String getUrlName() {
        return "jmeter";
    }
}

